/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.notification;

import de.hdskins.addon.network.Network;
import de.hdskins.core.api.util.UserNotificationUtil;
import de.hdskins.protocol.listener.PacketListener;
import de.hdskins.protocol.logger.InternalLogger;
import de.hdskins.protocol.packets.general.PacketDisconnect;
import de.hdskins.protocol.packets.reading.other.PacketServerDisplayAchievement;
import de.hdskins.protocol.packets.reading.other.PacketServerDisplayChat;
import javax.inject.Singleton;
import net.labymod.api.reference.annotation.Referenceable;

@Singleton
@Referenceable
public class NotificationListener {
    private final InternalLogger internalLogger;

    public NotificationListener(Network network) {
        this.internalLogger = network.getClient().getLogger();
        network.getClient().getPacketListenerRegistry().registerListeners((Object)this);
    }

    @PacketListener
    public void displayNotification(PacketServerDisplayAchievement packet) {
        UserNotificationUtil.notifyUser((PacketServerDisplayAchievement)packet);
    }

    @PacketListener
    public void displayNotification(PacketServerDisplayChat packet) {
        UserNotificationUtil.notifyUser((PacketServerDisplayChat)packet, (InternalLogger)this.internalLogger);
    }

    @PacketListener
    public void onDisconnect(PacketDisconnect packet) {
        UserNotificationUtil.notifyUser((PacketServerDisplayAchievement)packet);
    }
}

