/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.skin;

import de.hdskins.addon.HDSkinsAddon;
import de.hdskins.addon.network.Network;
import de.hdskins.addon.skin.SkinGameImageProcessor;
import de.hdskins.addon.skin.object.MojangSkinInfo;
import de.hdskins.addon.skin.object.SkinInfo;
import de.hdskins.addon.util.ProfileUtils;
import de.hdskins.protocol.PacketBase;
import de.hdskins.protocol.concurrent.FutureListener;
import de.hdskins.protocol.listener.PacketListener;
import de.hdskins.protocol.packets.core.disconnect.PacketClientServerDisconnect;
import de.hdskins.protocol.packets.core.texture.PacketServerTextureResponse;
import de.hdskins.protocol.packets.core.texture.PacketServerUpdateTexture;
import de.hdskins.protocol.packets.core.view.PacketClientViewEnter;
import de.hdskins.protocol.packets.core.view.PacketClientViewLeave;
import de.hdskins.protocol.packets.texture.Texture;
import de.hdskins.protocol.packets.texture.TextureMeta;
import de.hdskins.protocol.packets.texture.TextureType;
import de.hdskins.protocol.packets.texture.meta.SkinTextureMeta;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import net.labymod.api.Laby;
import net.labymod.api.client.network.ClientPacketListener;
import net.labymod.api.client.network.NetworkPlayerInfo;
import net.labymod.api.client.resources.CompletableResourceLocation;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.resources.texture.GameImageProcessor;
import net.labymod.api.client.session.MinecraftServices;
import net.labymod.api.mojang.texture.MojangTextureType;
import net.labymod.api.reference.annotation.Referenceable;
import org.jetbrains.annotations.NotNull;

@Singleton
@Referenceable
public class SkinService {
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1);
    private static final GameImageProcessor GAME_IMAGE_PROCESSOR = new SkinGameImageProcessor();
    private final Map<UUID, SkinInfo> playersWithSkin = new ConcurrentHashMap<UUID, SkinInfo>();
    private final Network network;

    public SkinService(Network network) {
        this.network = network;
        this.network.getClient().getPacketListenerRegistry().registerListeners((Object)this);
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            ClientPacketListener packetListener = Laby.labyAPI().minecraft().getClientPacketListener();
            if (packetListener == null) {
                return;
            }
            for (Map.Entry<UUID, SkinInfo> entry : this.playersWithSkin.entrySet()) {
                NetworkPlayerInfo networkPlayerInfo = packetListener.getNetworkPlayerInfo(entry.getKey());
                if (networkPlayerInfo == null) {
                    this.playersWithSkin.remove(entry.getKey());
                    continue;
                }
                if (((ResourceLocation)networkPlayerInfo.getSkin().getCompletableSkinTexture().getCompleted()).getNamespace().equalsIgnoreCase("hdskins")) continue;
                SkinInfo skinInfo = entry.getValue();
                this.applySkin(networkPlayerInfo, skinInfo.skinLocation(), skinInfo.skinVariant());
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    public void loadSkin(final @NotNull NetworkPlayerInfo info) {
        EXECUTOR_SERVICE.schedule(() -> {
            if (!this.network.getClient().isConnected()) {
                return;
            }
            final UUID requestingUniqueId = ProfileUtils.extractUniqueIdFromProfile(info, info.profile().getUniqueId());
            this.network.getClient().sendQuery((PacketBase)new PacketClientViewEnter(requestingUniqueId)).addListener((FutureListener)new FutureListener<PacketBase>(){

                public void nullResult() {
                    HDSkinsAddon.instance().logger().warn((CharSequence)("Failed to load skin for, got null result: " + String.valueOf(requestingUniqueId)), new Object[0]);
                }

                public void nonNullResult(@NotNull PacketBase packetBase) {
                    PacketServerTextureResponse packet = (PacketServerTextureResponse)packetBase;
                    Texture texture = (Texture)packet.getTextures().get(TextureType.SKIN);
                    if (texture == null) {
                        return;
                    }
                    SkinService.this.setSkin(info, texture.getTextureUrl(), texture.getTextureMeta());
                }

                public void cancelled() {
                    HDSkinsAddon.instance().logger().warn((CharSequence)("Failed to load skin for, got cancelled: " + String.valueOf(requestingUniqueId)), new Object[0]);
                }
            });
        }, 1L, TimeUnit.SECONDS);
    }

    public void handlePlayerQuit(@NotNull NetworkPlayerInfo info) {
        UUID uniqueId = ProfileUtils.extractUniqueIdFromProfile(info, info.profile().getUniqueId());
        if (!this.network.getClient().isConnected()) {
            return;
        }
        this.network.getClient().sendPacket((PacketBase)new PacketClientViewLeave(uniqueId));
    }

    public void setSkin(@NotNull NetworkPlayerInfo info, String textureUrl, TextureMeta textureMeta) {
        UUID uniqueId = ProfileUtils.extractUniqueIdFromProfile(info, info.profile().getUniqueId());
        ResourceLocation defaultSkin = Laby.references().mojangTextureService().getDefaultTexture(uniqueId, MojangTextureType.SKIN);
        if (textureUrl == null) {
            MojangSkinInfo mojangSkinInfo = ProfileUtils.getOriginalInfo(info);
            if (mojangSkinInfo != null) {
                Laby.labyAPI().minecraft().executeOnRenderThread(() -> Laby.references().mojangTextureService().applySkinTexture(uniqueId, mojangSkinInfo.slim() ? MinecraftServices.SkinVariant.SLIM : MinecraftServices.SkinVariant.CLASSIC, mojangSkinInfo.url()));
            } else {
                this.applySkin(info, defaultSkin, Laby.references().mojangTextureService().getVariant(defaultSkin));
            }
            this.playersWithSkin.remove(uniqueId);
            return;
        }
        try {
            CompletableResourceLocation resourceLocation = Laby.references().textureRepository().getOrRegisterTexture(ResourceLocation.create((String)"hdskins", (String)("textures" + ProfileUtils.getFilename(textureUrl))), defaultSkin, textureUrl, GAME_IMAGE_PROCESSOR, texture -> {});
            resourceLocation.addCompletableListener(() -> {
                SkinTextureMeta skinTextureMeta;
                if (resourceLocation.hasError()) {
                    return;
                }
                MinecraftServices.SkinVariant skinVariant = textureMeta != null ? ((skinTextureMeta = (SkinTextureMeta)textureMeta).isSlim() ? MinecraftServices.SkinVariant.SLIM : MinecraftServices.SkinVariant.CLASSIC) : MinecraftServices.SkinVariant.CLASSIC;
                this.applySkin(info, (ResourceLocation)resourceLocation.getCompleted(), skinVariant);
                this.playersWithSkin.put(uniqueId, new SkinInfo((ResourceLocation)resourceLocation.getCompleted(), skinVariant));
            });
        }
        catch (Throwable throwable) {
            HDSkinsAddon.instance().logger().error((CharSequence)("Failed to load skin for " + String.valueOf(uniqueId)), throwable);
        }
    }

    private void applySkin(NetworkPlayerInfo info, ResourceLocation resourceLocation, MinecraftServices.SkinVariant skinVariant) {
        Laby.labyAPI().minecraft().executeOnRenderThread(() -> {
            info.getSkin().setSkinTexture(resourceLocation);
            info.getSkin().setSkinVariant(skinVariant);
        });
    }

    public void reloadAllSkins() {
        ClientPacketListener packetListener = Laby.labyAPI().minecraft().getClientPacketListener();
        if (packetListener == null) {
            return;
        }
        for (NetworkPlayerInfo info : packetListener.getNetworkPlayerInfos()) {
            this.loadSkin(info);
        }
    }

    @PacketListener
    public void onUpdate(PacketServerUpdateTexture packet) {
        if (packet.getTextureType() != TextureType.SKIN) {
            return;
        }
        ClientPacketListener packetListener = Laby.labyAPI().minecraft().getClientPacketListener();
        if (packetListener == null) {
            return;
        }
        NetworkPlayerInfo networkPlayerInfo = packetListener.getNetworkPlayerInfo(packet.getUniqueId());
        if (networkPlayerInfo == null) {
            return;
        }
        this.setSkin(networkPlayerInfo, packet.getTextureUrl(), packet.getTextureMeta());
    }

    public void handleRemoveAll() {
        if (!this.network.getClient().isConnected()) {
            return;
        }
        this.network.getClient().sendPacket((PacketBase)new PacketClientServerDisconnect());
    }
}

