/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.skin.texture;

import de.hdskins.addon.HDSkinsAddon;
import de.hdskins.addon.network.Network;
import de.hdskins.addon.util.UUIDUtils;
import de.hdskins.protocol.PacketBase;
import de.hdskins.protocol.concurrent.FutureListener;
import de.hdskins.protocol.listener.PacketListener;
import de.hdskins.protocol.packets.core.texture.PacketServerTextureResponse;
import de.hdskins.protocol.packets.core.texture.loader.PacketServerTextureLoaderConfiguration;
import de.hdskins.protocol.packets.core.view.PacketClientViewEnter;
import de.hdskins.protocol.packets.texture.Texture;
import de.hdskins.protocol.packets.texture.TextureType;
import de.hdskins.protocol.packets.texture.meta.SkinTextureMeta;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.inject.Singleton;
import net.labymod.api.Laby;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.resources.texture.CompletableTextureImage;
import net.labymod.api.client.resources.texture.GameImage;
import net.labymod.api.client.resources.texture.GameImageProvider;
import net.labymod.api.client.resources.texture.TextureImage;
import net.labymod.api.client.resources.texture.TextureLoader;
import net.labymod.api.reference.annotation.Referenceable;
import net.labymod.api.util.io.web.WebInputStream;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.InputStreamRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Referenceable
public class HDTexturesLoader
implements TextureLoader {
    private final List<String> blockedTextures = new CopyOnWriteArrayList<String>();
    private final Network network;
    private final GameImageProvider gameImageProvider;
    private PacketServerTextureLoaderConfiguration configuration;
    private ExecutorService executorService;
    private Pattern urlRegex;

    public HDTexturesLoader(Network network) {
        this.network = network;
        this.network.getClient().getPacketListenerRegistry().registerListeners((Object)this);
        this.gameImageProvider = Laby.references().gameImageProvider();
    }

    public boolean canLoad(URI uri) {
        if (this.configuration == null) {
            return false;
        }
        String uriString = uri.toString();
        if (!this.configuration.isEnabled() || !this.network.getClient().isConnected() || this.blockedTextures.contains(uriString)) {
            return false;
        }
        if (this.executorService == null || this.urlRegex == null) {
            return false;
        }
        return this.urlRegex.matcher(uriString).matches();
    }

    public void loadTexture(final URI uri, final @Nullable ResourceLocation location, final CompletableTextureImage target) {
        final String mainUri = uri.toString();
        Matcher matcher = this.urlRegex.matcher(mainUri);
        if (!this.network.getClient().isConnected() || !matcher.matches()) {
            this.loadWithOtherLoader(mainUri, location, target);
            return;
        }
        final UUID uniqueId = UUIDUtils.parseUniqueId(matcher.group(this.configuration.getUniqueIdMatcherGroup()));
        if (uniqueId == null) {
            this.loadWithOtherLoader(mainUri, location, target);
            return;
        }
        this.network.getClient().sendQuery((PacketBase)new PacketClientViewEnter(uniqueId)).addListener((FutureListener)new FutureListener<PacketBase>(){

            public void nullResult() {
                HDTexturesLoader.this.loadWithOtherLoader(uri.toString(), location, target);
            }

            public void nonNullResult(@NotNull PacketBase packetBase) {
                PacketServerTextureResponse packet = (PacketServerTextureResponse)packetBase;
                Texture texture = (Texture)packet.getTextures().get(TextureType.SKIN);
                if (texture == null) {
                    HDTexturesLoader.this.loadWithOtherLoader(uri.toString(), location, target);
                    return;
                }
                boolean slim = texture.getTextureMeta() != null && ((SkinTextureMeta)texture.getTextureMeta()).isSlim();
                String url = texture.getTextureUrl();
                HDTexturesLoader.this.downloadSkin(uniqueId, mainUri, location, target, url, slim);
            }

            public void cancelled() {
                HDTexturesLoader.this.loadWithOtherLoader(uri.toString(), location, target);
            }
        });
    }

    private void downloadSkin(@NotNull UUID uniqueId, String mainUri, @Nullable ResourceLocation location, CompletableTextureImage target, String downloadUrl, boolean slim) {
        this.executorService.execute(() -> {
            Response response = ((InputStreamRequest)Request.ofInputStream().url(downloadUrl, new Object[0])).executeSync();
            if (response.isEmpty() || response.getStatusCode() != 200) {
                this.loadWithOtherLoader(mainUri, location, target);
                HDSkinsAddon.instance().logger().warn((CharSequence)"Failed to load skin for {}, result is not present with status code: {} for url {}", new Object[]{uniqueId, response.getStatusCode(), downloadUrl});
                return;
            }
            if (location != null) {
                location.metadata().set("variant", (Object)(slim ? "slim" : "classic"));
            }
            try {
                GameImage gameImage = this.gameImageProvider.getImage(ImageIO.read(((WebInputStream)response.get()).getInputStream()));
                TextureImage textureImage = new TextureImage(gameImage);
                target.executeCompletableListeners((Object)textureImage);
            }
            catch (IOException exception) {
                HDSkinsAddon.instance().logger().error((CharSequence)"Failed to load skin for {}", new Object[]{uniqueId, exception});
                this.loadWithOtherLoader(mainUri, location, target);
            }
        });
    }

    private void loadWithOtherLoader(@NotNull String url, @Nullable ResourceLocation location, CompletableTextureImage target) {
        this.blockedTextures.add(url);
        Laby.references().textureRepository().executeTextureLoader(url, location, target);
    }

    @PacketListener
    public void onTextureLoaderConfigUpdate(PacketServerTextureLoaderConfiguration packet) {
        this.configuration = packet;
        int maxThreads = this.configuration.getThreads();
        if (maxThreads > 16) {
            maxThreads = 16;
        }
        this.executorService = Executors.newFixedThreadPool(maxThreads);
        this.urlRegex = Pattern.compile(this.configuration.getTextureLoadUrl());
    }
}

