/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.skin;

import net.labymod.api.Laby;
import net.labymod.api.client.resources.texture.GameImage;
import net.labymod.api.client.resources.texture.GameImageProcessor;
import net.labymod.api.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class SkinGameImageProcessor
implements GameImageProcessor {
    private GameImage image;

    @NotNull
    public GameImage processImage(@NotNull GameImage image) {
        this.image = image;
        GameImage in = this.image;
        if (in.getWidth() == in.getHeight()) {
            this.removeTransparency(in, false);
            return in;
        }
        if (!this.isResolutionValid()) {
            throw new IllegalArgumentException("Invalid image dimensions for skin: " + in.getWidth() + "x" + in.getHeight());
        }
        GameImage out = Laby.references().gameImageProvider().createImage(in.getWidth(), in.getWidth());
        int f = in.getWidth() / 64;
        out.drawImage(in, 0, 0, 0, 0, 64 * f, 16 * f);
        out.drawImage(in, 16 * f, 16 * f, 16 * f, 16 * f, 24 * f, 16 * f);
        out.drawImage(in, 40 * f, 16 * f, 40 * f, 16 * f, 16 * f, 16 * f);
        this.drawFlipped16by16(out, in, 32 * f, 48 * f, 40 * f, 16 * f, f);
        out.drawImage(in, 0, 16 * f, 0, 16 * f, 16 * f, 16 * f);
        this.drawFlipped16by16(out, in, 16 * f, 48 * f, 0, 16 * f, f);
        this.removeTransparency(out, false);
        return out;
    }

    private void removeTransparency(GameImage out, boolean legacySkin) {
        out.setNoAlpha(0, 0, 32, 16);
        if (legacySkin) {
            this.doNotchTransparencyHack(out, 32, 0, 64, 32);
        }
        out.setNoAlpha(0, 16, 64, 16);
        out.setNoAlpha(16, 48, 32, 16);
    }

    private void doNotchTransparencyHack(GameImage out, int startX, int startY, int endX, int endY) {
        int y;
        int x;
        for (x = startX; x < endX; ++x) {
            for (y = startY; y < endY; ++y) {
                if ((this.image.getARGB(x, y) >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (x = startX; x < endX; ++x) {
            for (y = startY; y < endY; ++y) {
                out.setARGB(x, y, this.image.getARGB(x, y) & 0xFFFFFF);
            }
        }
    }

    private void drawFlipped16by16(GameImage out, GameImage in, int dx, int dy, int sx, int sy, int f) {
        out.drawImage(in, dx, dy, sx, sy, 16 * f, 16 * f);
        out.flipHorizontally(dx, dy + 4 * f, 4 * f, 12 * f);
        out.flipHorizontally(dx + 4 * f, dy + 4 * f, 4 * f, 12 * f);
        out.flipHorizontally(dx + 8 * f, dy + 4 * f, 4 * f, 12 * f);
        out.flipHorizontally(dx + 12 * f, dy + 4 * f, 4 * f, 12 * f);
        out.flipHorizontally(dx + 4 * f, dy, 4 * f, 4 * f);
        out.flipHorizontally(dx + 8 * f, dy, 4 * f, 4 * f);
        out.swap(dx, dy + 4 * f, dx + 8 * f, dy + 4 * f, 4 * f, 12 * f);
    }

    public boolean isResolutionValid() {
        if (!MathHelper.isPowerOfTwo((int)this.image.getWidth()) || this.image.getWidth() < 64) {
            return false;
        }
        return this.image.getWidth() == this.image.getHeight() || this.image.getWidth() == this.image.getHeight() * 2;
    }
}

