/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.tag;

import de.hdskins.addon.network.Network;
import de.hdskins.protocol.listener.PacketListener;
import de.hdskins.protocol.packets.core.tag.PacketServerUpdateTeamTag;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import net.labymod.api.reference.annotation.Referenceable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Referenceable
public class TeamTagStorage {
    private final Map<UUID, Component> teamTags = new ConcurrentHashMap<UUID, Component>();

    public TeamTagStorage(Network network) {
        network.getClient().getPacketListenerRegistry().registerListeners((Object)this);
    }

    @PacketListener
    public void storeNameTag(PacketServerUpdateTeamTag packet) {
        String tag = packet.getTag();
        if (tag == null) {
            this.teamTags.remove(packet.getUniqueId());
            return;
        }
        this.teamTags.put(packet.getUniqueId(), LegacyComponentSerializer.legacySection().deserialize(tag));
    }

    @Nullable
    public Component getTag(@NotNull UUID uniqueId) {
        return this.teamTags.getOrDefault(uniqueId, null);
    }

    public void removeTag(@NotNull UUID uniqueId) {
        this.teamTags.remove(uniqueId);
    }

    public void removeAll() {
        this.teamTags.clear();
    }
}

