/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.tag.online;

import de.hdskins.protocol.listener.PacketListener;
import de.hdskins.protocol.packets.core.other.PacketServerUserOnlineStatus;
import de.hdskins.protocol.packets.core.role.PacketServerRoleInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Singleton;
import net.labymod.api.reference.annotation.Referenceable;
import org.jetbrains.annotations.NotNull;

@Singleton
@Referenceable
public class StaffOnlineStatusStorage {
    private boolean allowToDisplayOnlineUsers = false;
    private final List<UUID> onlineUsers = new ArrayList<UUID>();

    @PacketListener
    public void onRoleUpdate(PacketServerRoleInformation packet) {
        this.allowToDisplayOnlineUsers = packet.isAllowToSeeOnlineUsers();
    }

    @PacketListener
    public void onOnlineStatusUpdate(PacketServerUserOnlineStatus packet) {
        if (packet.isOnline()) {
            this.onlineUsers.add(packet.getUniqueId());
        } else {
            this.onlineUsers.remove(packet.getUniqueId());
        }
    }

    @NotNull
    public List<UUID> getOnlineUsers() {
        return this.onlineUsers;
    }

    public boolean isAllowToDisplayOnlineUsers() {
        return this.allowToDisplayOnlineUsers;
    }
}

