/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.util;

import java.util.UUID;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UUIDUtils {
    private static final Pattern PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");

    @Nullable
    public static UUID parseUndashedUUID(@NotNull String raw) {
        try {
            return UUID.fromString(PATTERN.matcher(raw).replaceAll("$1-$2-$3-$4-$5"));
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public static UUID parseUniqueId(@NotNull String entry) {
        try {
            return UUID.fromString(entry);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }
}

