/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.invite;

import de.hdskins.addon.network.Network;
import de.hdskins.protocol.PacketBase;
import de.hdskins.protocol.concurrent.FutureListener;
import de.hdskins.protocol.listener.PacketListener;
import de.hdskins.protocol.packets.core.invite.PacketClientInviteRequest;
import de.hdskins.protocol.packets.core.invite.PacketServerInviteAvailable;
import de.hdskins.protocol.packets.core.invite.PacketServerInviteResponse;
import javax.inject.Singleton;
import net.labymod.api.Laby;
import net.labymod.api.client.chat.ChatExecutor;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.interaction.AbstractBulletPoint;
import net.labymod.api.reference.annotation.Referenceable;
import org.jetbrains.annotations.NotNull;

@Singleton
@Referenceable
public class InviteHandler
extends AbstractBulletPoint {
    private static final Component HDSKINS_INVITE_PREFIX = ((TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)"HDSkins Invites", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.space());
    private final Network network;
    private final ChatExecutor chatExecutor = Laby.labyAPI().minecraft().chatExecutor();

    public InviteHandler(Network network) {
        super((Component)Component.translatable((String)"hdskins.inviter.point.title", (Component[])new Component[0]));
        this.network = network;
        network.getClient().getPacketListenerRegistry().registerListeners((Object)this);
    }

    public void execute(Player player) {
        if (!this.network.getClient().isConnected()) {
            this.displayMessage("\u00a7cYou are not connected to the HDSkins network. Please try again later.");
            return;
        }
        this.network.getClient().sendQuery((PacketBase)new PacketClientInviteRequest(player.profile().getUsername())).addListener((FutureListener)new FutureListener<PacketBase>(){

            public void nullResult() {
                InviteHandler.this.displayMessage("\u00a7cAn error occurred while sending the invite request. The server did not respond. Please try again later.");
            }

            public void nonNullResult(@NotNull PacketBase packetBase) {
                PacketServerInviteResponse packet = (PacketServerInviteResponse)packetBase;
                if (packet.isSuccess()) {
                    Laby.labyAPI().interactionMenuRegistry().unregister("hdskins-invite-point");
                }
                InviteHandler.this.displayMessage(packet.getMessage());
            }

            public void cancelled() {
                InviteHandler.this.displayMessage("\u00a7cAn error occurred while sending the invite request. The request was cancelled. Please try again later.");
            }
        });
    }

    @PacketListener
    public void onInviteAvailable(PacketServerInviteAvailable packet) {
        Laby.labyAPI().interactionMenuRegistry().unregister("hdskins-invite-point");
        Laby.labyAPI().interactionMenuRegistry().register("hdskins-invite-point", (Object)this);
    }

    private void displayMessage(@NotNull String message) {
        this.chatExecutor.displayClientMessage(((TextComponent)Component.empty().append(HDSKINS_INVITE_PREFIX)).append(LegacyComponentSerializer.legacyAmpersand().deserialize(message)));
    }
}

