/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.util;

import com.google.gson.JsonObject;
import de.hdskins.addon.skin.object.MojangSkinInfo;
import de.hdskins.addon.util.UUIDUtils;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import net.labymod.api.client.network.NetworkPlayerInfo;
import net.labymod.api.mojang.Property;
import net.labymod.api.util.GsonUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileUtils {
    @NotNull
    public static UUID extractUniqueIdFromProfile(@NotNull NetworkPlayerInfo info, @NotNull UUID fallback) {
        JsonObject jsonObject;
        UUID parsed;
        Collection properties = info.profile().getProperties().getOrDefault("textures", null);
        if (properties != null && !properties.isEmpty() && (parsed = UUIDUtils.parseUndashedUUID((jsonObject = GsonUtil.parse((String)new String(Base64.getDecoder().decode(((Property)properties.stream().toList().get(0)).getValue()))).getAsJsonObject()).get("profileId").getAsString())) != null) {
            return parsed;
        }
        return fallback;
    }

    @Nullable
    public static MojangSkinInfo getOriginalInfo(@NotNull NetworkPlayerInfo info) {
        Collection properties = info.profile().getProperties().getOrDefault("textures", null);
        if (properties != null && !properties.isEmpty()) {
            JsonObject metadataObject;
            JsonObject jsonObject = GsonUtil.parse((String)new String(Base64.getDecoder().decode(((Property)properties.stream().toList().get(0)).getValue()))).getAsJsonObject();
            if (!jsonObject.has("textures")) {
                return null;
            }
            JsonObject texturesObject = jsonObject.get("textures").getAsJsonObject();
            if (!texturesObject.has("SKIN")) {
                return null;
            }
            JsonObject skinObject = texturesObject.get("SKIN").getAsJsonObject();
            boolean slim = false;
            if (skinObject.has("metadata") && (metadataObject = skinObject.get("metadata").getAsJsonObject()).has("model")) {
                slim = metadataObject.get("model").getAsString().equalsIgnoreCase("slim");
            }
            return new MojangSkinInfo(skinObject.get("url").getAsString(), slim);
        }
        return null;
    }

    public static String getFilename(String url) {
        int splitter = url.lastIndexOf(47);
        if (splitter == -1) {
            return url;
        }
        return url.substring(splitter + 1);
    }
}

