/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.itemphysics;

import net.labymod.addons.itemphysics.ItemPhysicsConfiguration;
import net.labymod.addons.itemphysics.core.generated.DefaultReferenceStorage;
import net.labymod.addons.itemphysics.listener.GameRenderListener;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.loader.MinecraftVersions;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.util.time.TimeUtil;

@AddonMain
public class ItemPhysics
extends LabyAddon<ItemPhysicsConfiguration> {
    private static final boolean USE_LEGACY_SPEED = MinecraftVersions.V1_12_2.orOlder();
    private static final float LEGACY_SPEED = 2.0E8f;
    private static final float MODERN_SPEED = 1.0E8f;
    private static ItemPhysics instance;
    private long lastRenderTime;

    public ItemPhysics() {
        instance = this;
    }

    public static ItemPhysics get() {
        return instance;
    }

    public static float getRotation() {
        return (float)(TimeUtil.getNanoTime() - ItemPhysics.get().lastRenderTime) / (USE_LEGACY_SPEED ? 2.0E8f : 1.0E8f);
    }

    protected void enable() {
        this.registerSettingCategory();
        this.registerListener(new GameRenderListener(this));
    }

    protected Class<ItemPhysicsConfiguration> configurationClass() {
        return ItemPhysicsConfiguration.class;
    }

    public DefaultReferenceStorage referenceStorage() {
        return (DefaultReferenceStorage)this.referenceStorageAccessor();
    }

    public void updateLastRenderTime() {
        this.lastRenderTime = TimeUtil.getNanoTime();
    }
}

