/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.itemphysics;

import javax.inject.Singleton;
import net.labymod.addons.itemphysics.ItemPhysics;
import net.labymod.addons.itemphysics.ItemPhysicsConfiguration;
import net.labymod.addons.itemphysics.bridge.BakedModel;
import net.labymod.addons.itemphysics.bridge.EntityMotion;
import net.labymod.addons.itemphysics.bridge.ItemEntity;
import net.labymod.addons.itemphysics.bridge.RandomSource;
import net.labymod.addons.itemphysics.bridge.VersionBridge;
import net.labymod.addons.itemphysics.util.FloatOptional;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.world.item.ItemStack;
import net.labymod.api.loader.MinecraftVersions;
import net.labymod.api.reference.annotation.Referenceable;
import net.labymod.api.util.math.vector.FloatVector3;

@Singleton
@Referenceable
public class ItemPhysicsRenderer {
    private static final boolean MODERN_PHYSIC_TRANSLATE = MinecraftVersions.V1_12_2.orNewer();
    private static final long AIR_SEED = 187L;
    private static final float HALF_PI = 1.5707964f;
    private static final float ITEM_HEIGHT_OFFSET = 0.2f;
    private final VersionBridge bridge;

    public ItemPhysicsRenderer(VersionBridge bridge) {
        this.bridge = bridge;
    }

    public boolean render(Stack stack, Object bufferSource, ItemEntity itemEntity, float age, ItemStack itemStack, BakedModel model, RandomSource random, int packedLightCoords) {
        return this.render(stack, bufferSource, itemEntity, age, itemStack, model, random, packedLightCoords, false);
    }

    public boolean render(Stack stack, Object bufferSource, ItemEntity itemEntity, float age, ItemStack itemStack, BakedModel model, RandomSource random, int packedLightCoords, boolean renderOutlines) {
        float offsetZ;
        float offsetY;
        float offsetX;
        boolean applyEffects;
        EntityMotion entityMotion;
        if (!((Boolean)((ItemPhysicsConfiguration)ItemPhysics.get().configuration()).enabled().get()).booleanValue()) {
            return false;
        }
        if (age == 0.0f || model == null) {
            return false;
        }
        this.bridge.preRenderItem(itemEntity, renderOutlines);
        stack.push();
        random.itemPhysics$setSeed(itemStack.isAir() ? 187L : (long)(this.bridge.getItemId(itemStack) + itemStack.getCurrentDamageValue()));
        int modelCount = this.getModelCount(itemStack);
        boolean gui3D = true;
        model.itemPhysics$isGui3D();
        float rotatedBy = ItemPhysics.getRotation() * ((Float)((ItemPhysicsConfiguration)ItemPhysics.get().configuration()).rotationSpeed().get()).floatValue();
        if (this.bridge.isGamePaused()) {
            rotatedBy = 0.0f;
        }
        if ((entityMotion = (EntityMotion)((Object)itemEntity)).itemPhysics$hasStuckSpeedMultiplier() && entityMotion.itemPhysics$lengthSqr() > 0.0) {
            rotatedBy *= (float)(entityMotion.itemPhysics$getStuckSpeedMultiplierX() * (double)0.2f);
        }
        stack.rotateRadians(1.5707964f, 1.0f, 0.0f, 0.0f);
        stack.rotateRadians(itemEntity.itemPhysics$getYRot(), 0.0f, 0.0f, 1.0f);
        boolean bl = applyEffects = age != 0.0f && (gui3D || this.bridge.hasOptions());
        if (applyEffects) {
            this.applyRotations(stack, itemEntity, gui3D, rotatedBy);
        }
        if (!gui3D) {
            FloatVector3 groundScale = this.bridge.getGroundScale(model);
            offsetX = -0.0f * (float)(modelCount - 1) * 0.5f * groundScale.getX();
            offsetY = -0.0f * (float)(modelCount - 1) * 0.5f * groundScale.getY();
            offsetZ = -0.09375f * (float)(modelCount - 1) * 0.5f * groundScale.getZ();
            stack.translate(offsetX, offsetY, offsetZ);
        }
        for (int index = 0; index < modelCount; ++index) {
            stack.push();
            if (index > 0 && gui3D) {
                offsetX = (random.itemPhysics$nextFloat() * 2.0f - 1.0f) * 0.15f;
                offsetY = (random.itemPhysics$nextFloat() * 2.0f - 1.0f) * 0.15f;
                offsetZ = (random.itemPhysics$nextFloat() * 2.0f - 1.0f) * 0.15f;
                stack.translate(offsetX, offsetY, offsetZ);
            }
            this.bridge.renderItem(itemStack, stack, bufferSource, packedLightCoords, model);
            stack.pop();
            if (gui3D) continue;
            stack.translate(0.0f, 0.0f, 0.09375f);
        }
        stack.pop();
        this.bridge.postRenderItem(itemEntity, renderOutlines);
        return true;
    }

    private void applyRotations(Stack stack, ItemEntity itemEntity, boolean gui3D, float rotatedBy) {
        if (gui3D) {
            if (!itemEntity.itemPhysics$isOnGround()) {
                rotatedBy *= 2.0f;
                FloatOptional fluidViscosity = this.bridge.getFluidViscosity(itemEntity, true);
                if (fluidViscosity.isSet()) {
                    rotatedBy /= 1.0f + fluidViscosity.get();
                }
                itemEntity.itemPhysics$setXRot(itemEntity.itemPhysics$getXRot() + rotatedBy);
            }
        } else if (!(Double.isNaN(itemEntity.itemPhysics$getPosX()) || Double.isNaN(itemEntity.itemPhysics$getPosY()) || Double.isNaN(itemEntity.itemPhysics$getPosZ()))) {
            if (itemEntity.itemPhysics$isOnGround()) {
                itemEntity.itemPhysics$setXRot(0.0f);
            } else {
                rotatedBy *= 2.0f;
                FloatOptional fluidViscosity = this.bridge.getFluidViscosity(itemEntity, false);
                if (fluidViscosity.isSet()) {
                    rotatedBy /= 1.0f + fluidViscosity.get();
                }
                itemEntity.itemPhysics$setXRot(itemEntity.itemPhysics$getXRot() + rotatedBy);
            }
        }
        this.preItemTranslate(stack, itemEntity, gui3D);
        stack.rotateRadians(itemEntity.itemPhysics$getXRot(), 1.0f, 0.0f, 0.0f);
        this.postItemTranslate(stack, itemEntity, gui3D);
    }

    private void preItemTranslate(Stack stack, ItemEntity itemEntity, boolean gui3D) {
        if (!MODERN_PHYSIC_TRANSLATE) {
            return;
        }
        if (gui3D) {
            stack.translate(0.0f, -0.2f, -0.08f);
        } else if (this.bridge.isSpecialBlock(itemEntity)) {
            stack.translate(0.0f, 0.0f, -0.14f);
        } else {
            stack.translate(0.0f, 0.0f, -0.04f);
        }
        if (gui3D) {
            stack.translate(0.0f, 0.2f, 0.0f);
        }
    }

    private void postItemTranslate(Stack stack, ItemEntity itemEntity, boolean gui3D) {
        if (!MODERN_PHYSIC_TRANSLATE) {
            return;
        }
        if (gui3D) {
            stack.translate(0.0f, -0.2f, 0.0f);
        }
    }

    private int getModelCount(ItemStack itemStack) {
        int size = itemStack.getSize();
        if (size > 48) {
            return 5;
        }
        if (size > 32) {
            return 4;
        }
        if (size > 16) {
            return 3;
        }
        if (size > 1) {
            return 2;
        }
        return 1;
    }
}

