/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.keystrokes;

import net.labymod.addons.keystrokes.hudwidget.KeyStrokesHudWidgetConfig;
import net.labymod.addons.keystrokes.util.KeyTracker;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.render.font.ComponentRenderer;

public class KeyStrokeConfig {
    private static final ComponentRenderer TEXT_RENDERER = Laby.labyAPI().renderPipeline().componentRenderer();
    private Key key;
    private float x;
    private float y;
    private float width = 20.0f;
    private boolean bigSpace;
    private transient boolean pressed;
    private transient long lastPressedUpdate;
    private transient KeyTracker keyTracker;

    public KeyStrokeConfig(Key key, float x, float y) {
        this.key = key;
        this.updateWidth(key);
        this.x = x;
        this.y = y;
    }

    public void updatePressed(boolean pressed) {
        if (this.pressed == pressed) {
            return;
        }
        if (pressed && this.keyTracker != null) {
            this.keyTracker.press();
        }
        this.pressed = pressed;
        this.lastPressedUpdate = System.currentTimeMillis();
    }

    public void updateWidth(Key key) {
        if (this.bigSpace && key == Key.SPACE) {
            this.width = 64.0f;
            return;
        }
        int padding = 8;
        float actualWidth = TEXT_RENDERER.width((Component)Component.text((String)this.getKeyName())) + (float)padding;
        float defaultWidth = 20.0f;
        if (key == MouseButton.LEFT || key == MouseButton.MIDDLE || key == MouseButton.RIGHT) {
            defaultWidth = defaultWidth * 1.5f + 1.0f;
        }
        this.width = Math.max(actualWidth, defaultWidth);
    }

    public void updateBigSpace(boolean bigSpace) {
        if (this.bigSpace == bigSpace || this.key != Key.SPACE) {
            return;
        }
        this.bigSpace = bigSpace;
        this.updateWidth(this.key);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void updatePosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Key key() {
        return this.key;
    }

    public String getKeyName() {
        Key key = this.key;
        if (!(key instanceof MouseButton)) {
            return key.getName();
        }
        if (key == MouseButton.LEFT) {
            return "LMB";
        }
        if (key == MouseButton.RIGHT) {
            return "RMB";
        }
        if (key == MouseButton.MIDDLE) {
            return "MMB";
        }
        return key.getName();
    }

    public float getHeight(KeyStrokesHudWidgetConfig config) {
        return this.getHeight((Boolean)config.fancySpace().get());
    }

    public float getHeight(boolean fancySpace) {
        if (this.key != Key.SPACE || !fancySpace) {
            return 20.0f;
        }
        return 14.0f;
    }

    public long getLastPressedUpdate() {
        return this.lastPressedUpdate;
    }

    public void enableKeyTracking() {
        if (this.keyTracker != null || this.key != MouseButton.LEFT && this.key != MouseButton.RIGHT) {
            return;
        }
        this.keyTracker = new KeyTracker();
    }

    public void disableKeyTracking() {
        if (this.keyTracker == null) {
            return;
        }
        this.keyTracker = null;
    }

    public KeyTracker getKeyTracker() {
        return this.keyTracker;
    }
}

