/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.keystrokes.widgets;

import java.awt.Color;
import java.util.Set;
import net.labymod.addons.keystrokes.KeyStrokeConfig;
import net.labymod.addons.keystrokes.hudwidget.KeyStrokesHudWidgetConfig;
import net.labymod.addons.keystrokes.widgets.KeyStrokeWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.state.states.GuiRectangleRenderState;
import net.labymod.api.client.gui.screen.widget.AbstractWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.util.bounds.ModifyReason;
import net.labymod.api.util.bounds.Point;
import net.labymod.api.util.bounds.Rectangle;

public class KeyStrokeGridWidget
extends AbstractWidget<KeyStrokeWidget> {
    public static final float DEFAULT_HEIGHT = 20.0f;
    public static final float DEFAULT_WIDTH = 20.0f;
    protected static final ModifyReason REASON = ModifyReason.of((String)"keyStrokeAdjustment");
    protected final KeyStrokesHudWidgetConfig config;
    protected boolean reload;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;

    protected KeyStrokeGridWidget(KeyStrokesHudWidgetConfig config) {
        this.config = config;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.reload = true;
    }

    protected void updateWidgetBounds(Rectangle bounds) {
        this.updateWidgetBounds(Point.fixed((int)((int)bounds.getX()), (int)((int)bounds.getY())), true, false);
    }

    protected void updateWidgetBounds(Point point, boolean adjustBounds, boolean centered) {
        if (this.reload) {
            this.children.clear();
        }
        this.minX = 0.0f;
        this.minY = 0.0f;
        this.maxX = 0.0f;
        this.maxY = 0.0f;
        KeyStrokeConfig anchor = this.config.anchorConfig();
        anchor.updateWidth(anchor.key());
        float anchorX = anchor.getX();
        float anchorY = anchor.getY();
        float width = anchorX + anchor.getWidth();
        float height = anchorY + 20.0f;
        Set<KeyStrokeConfig> keyStrokes = this.config.getKeyStrokes();
        for (KeyStrokeConfig keyStroke : keyStrokes) {
            Key key = keyStroke.key();
            if (keyStroke == anchor) continue;
            keyStroke.updateWidth(key);
            float keyHeight = keyStroke.getHeight(this.config);
            if (adjustBounds) {
                if (keyStroke.getX() >= 0.0f && width < anchorX + keyStroke.getX() + keyStroke.getWidth()) {
                    width = anchorX + keyStroke.getX() + keyStroke.getWidth();
                }
                if (keyStroke.getY() >= 0.0f && height < anchorY + keyStroke.getY() + keyHeight) {
                    height = anchorY + keyStroke.getY() + keyHeight;
                }
            }
            if (this.minX > keyStroke.getX()) {
                this.minX = keyStroke.getX();
            }
            if (this.minY > keyStroke.getY()) {
                this.minY = keyStroke.getY();
            }
            if (this.maxX < keyStroke.getX() + keyStroke.getWidth()) {
                this.maxX = keyStroke.getX() + keyStroke.getWidth();
            }
            if (!(this.maxY < keyStroke.getY() + keyHeight)) continue;
            this.maxY = keyStroke.getY() + keyHeight;
        }
        float x = (float)point.getX() + anchorX;
        float y = (float)point.getY() + anchorY;
        if (centered) {
            x -= (this.maxX - this.minX) / 2.0f;
            y -= (this.maxY - this.minX) / 2.0f;
        }
        for (KeyStrokeConfig keyStroke : keyStrokes) {
            float widgetY;
            float widgetX;
            KeyStrokeWidget keyStrokeWidget = null;
            if (this.reload) {
                keyStrokeWidget = new KeyStrokeWidget(keyStroke.key(), keyStroke, this.config);
            } else {
                keyStrokeWidget = (KeyStrokeWidget)this.findFirstChildIf(child -> child.config() == keyStroke);
                if (keyStrokeWidget == null) break;
            }
            Bounds widgetBounds = keyStrokeWidget.bounds();
            if (keyStroke == anchor) {
                widgetX = x;
                widgetY = y;
            } else {
                widgetX = x + keyStroke.getX();
                widgetY = y + keyStroke.getY();
            }
            widgetBounds.setPosition((float)((int)widgetX), (float)((int)widgetY), REASON);
            widgetBounds.setSize((float)((int)keyStroke.getWidth()), (float)((int)keyStroke.getHeight(this.config)), REASON);
            if (!this.reload) continue;
            if (this.initialized) {
                this.addChildInitialized((Widget)keyStrokeWidget);
                continue;
            }
            this.addChild((Widget)keyStrokeWidget);
        }
        if (adjustBounds) {
            this.bounds().setSize((float)((int)width), (float)((int)height), REASON);
        }
        this.reload = false;
    }

    protected void reload() {
        this.reload = true;
    }

    protected void renderDebug(ScreenContext context) {
        if (!this.renderDebug()) {
            return;
        }
        Bounds bounds = this.bounds();
        ScreenCanvas canvas = context.canvas();
        canvas.submitOutlineRect((Rectangle)bounds, 1.0f, 0, Color.RED.getRGB());
        canvas.submitGuiRect(bounds.getX(), bounds.getCenterY() - 0.5f, bounds.getMaxX(), bounds.getCenterY() + 0.5f, GuiRectangleRenderState.RectConfig.builder().setArgb(Color.RED.getRGB()).build());
        canvas.submitGuiRect(bounds.getCenterX() - 0.5f, bounds.getY(), bounds.getCenterX() + 0.5f, bounds.getMaxY(), GuiRectangleRenderState.RectConfig.builder().setArgb(Color.RED.getRGB()).build());
        Key key = (Key)this.config.base().get();
        KeyStrokeWidget anchorWidget = (KeyStrokeWidget)this.findFirstChildIf(child -> child.key() == key);
        if (anchorWidget == null) {
            return;
        }
        KeyStrokeConfig config = anchorWidget.config();
        canvas.submitOutlineRect((Rectangle)anchorWidget.bounds(), 1.0f, 0, Color.YELLOW.getRGB());
        canvas.submitGuiRect(anchorWidget.bounds().getX() - config.getX(), anchorWidget.bounds().getY() - config.getY(), 1.0f, 1.0f, GuiRectangleRenderState.RectConfig.builder().setArgb(Color.YELLOW.getRGB()).build());
    }

    protected boolean renderDebug() {
        return false;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }
}

