/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.keystrokes.activities;

import java.util.Set;
import java.util.function.Consumer;
import net.labymod.addons.keystrokes.KeyStrokeConfig;
import net.labymod.addons.keystrokes.activities.KeyStrokeManageWidget;
import net.labymod.addons.keystrokes.event.KeyStrokeUpdateEvent;
import net.labymod.addons.keystrokes.hudwidget.KeyStrokesHudWidgetConfig;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.key.InputType;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.popup.SimpleAdvancedPopup;
import net.labymod.api.event.Event;
import net.labymod.api.event.Subscribe;

@Link(value="edit.lss")
@AutoActivity
public class KeyStrokeManageActivity
extends Activity {
    private static final MutableMouse DUMMY_MOUSE = new MutableMouse(-5.0, -5.0);
    private final KeyStrokesHudWidgetConfig hudWidgetConfig;
    private final KeyStrokeManageWidget manageWidget;
    private Consumer<KeyStrokeConfig> addCallback;
    private FlexibleContentWidget content;
    private DivWidget overlayWidget;
    private KeyStrokeConfig selected;

    public KeyStrokeManageActivity(KeyStrokesHudWidgetConfig hudWidgetConfig) {
        this.hudWidgetConfig = hudWidgetConfig;
        this.manageWidget = new KeyStrokeManageWidget(this.hudWidgetConfig, selected -> {
            this.selected = selected;
        });
        this.manageWidget.addId("manage");
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.content = new FlexibleContentWidget();
        this.content.addId("content");
        DivWidget manageContainer = new DivWidget();
        manageContainer.addId("manage-container");
        this.overlayWidget = this.overlayWidget();
        this.overlayWidget.addId("overlay");
        this.overlayWidget.setVisible(false);
        manageContainer.addChild((Widget)this.overlayWidget);
        manageContainer.addChild((Widget)this.manageWidget);
        this.content.addFlexibleContent((Widget)manageContainer);
        HorizontalListWidget manageButtonContainer = new HorizontalListWidget();
        manageButtonContainer.addId("manage-button-container");
        ButtonWidget addButton = ButtonWidget.i18n((String)"keystrokes.activity.edit.add.text");
        addButton.addId("add-button");
        addButton.setPressable(() -> {
            this.overlayWidget.setVisible(true);
            this.addCallback = config -> {
                if (((Boolean)this.hudWidgetConfig.trackMouseCPS().get()).booleanValue()) {
                    config.enableKeyTracking();
                }
                this.hudWidgetConfig.addKeyStroke((KeyStrokeConfig)config);
                this.manageWidget.select((KeyStrokeConfig)config);
                Laby.fireEvent((Event)new KeyStrokeUpdateEvent(true));
            };
        });
        manageButtonContainer.addEntry((Widget)addButton);
        ButtonWidget removeButton = ButtonWidget.i18n((String)"keystrokes.activity.edit.remove.text");
        removeButton.addId("remove-button");
        removeButton.setPressable(() -> {
            if (this.selected == null) {
                return;
            }
            Set<KeyStrokeConfig> keyStrokes = this.hudWidgetConfig.getKeyStrokes();
            if (keyStrokes.size() == 1) {
                this.overlayWidget.setVisible(true);
                this.addCallback = config -> {
                    if (config == this.selected) {
                        this.manageWidget.select(this.selected);
                        return;
                    }
                    this.hudWidgetConfig.base().set((Object)config.key());
                    config.updatePosition(this.selected.getX(), this.selected.getY());
                    this.hudWidgetConfig.removeKeyStroke(this.selected);
                    this.hudWidgetConfig.addKeyStroke((KeyStrokeConfig)config);
                    Laby.fireEvent((Event)new KeyStrokeUpdateEvent(true));
                    this.manageWidget.select((KeyStrokeConfig)config);
                };
                return;
            }
            if (this.selected.key() == this.hudWidgetConfig.base().get()) {
                KeyStrokeConfig config2 = null;
                for (KeyStrokeConfig keyStroke : this.hudWidgetConfig.getKeyStrokes()) {
                    if (keyStroke == this.selected) continue;
                    config2 = keyStroke;
                    break;
                }
                if (config2 == null) {
                    return;
                }
                this.hudWidgetConfig.removeKeyStroke(this.selected);
                float anchorX = config2.getX();
                float anchorY = config2.getY();
                for (KeyStrokeConfig keyStroke : this.hudWidgetConfig.getKeyStrokes()) {
                    if (keyStroke == config2) continue;
                    float x = keyStroke.getX();
                    float y = keyStroke.getY();
                    x = x == anchorX ? 0.0f : (x -= anchorX);
                    y = y == anchorY ? 0.0f : (y -= anchorY);
                    keyStroke.updatePosition(x, y);
                }
                config2.updatePosition(anchorX + this.selected.getX(), anchorY + this.selected.getY());
                this.hudWidgetConfig.base().set((Object)config2.key());
            }
            this.hudWidgetConfig.removeKeyStroke(this.selected);
            this.manageWidget.updateSize();
            Laby.fireEvent((Event)new KeyStrokeUpdateEvent(true));
            this.manageWidget.select(null);
        });
        manageButtonContainer.addEntry((Widget)removeButton);
        ButtonWidget resetButton = ButtonWidget.i18n((String)"labymod.ui.button.reset");
        resetButton.addId("reset-button");
        resetButton.setPressable(() -> SimpleAdvancedPopup.builder().title((Component)Component.text((String)"Reset Keystrokes?")).description((Component)Component.text((String)"Are you sure you want to reset all keystrokes? This action cannot be undone.")).addButton(SimpleAdvancedPopup.SimplePopupButton.cancel()).addButton(SimpleAdvancedPopup.SimplePopupButton.confirm(button -> {
            this.hudWidgetConfig.setDefaultKeyStrokes();
            this.hudWidgetConfig.refreshCPSTracking();
            this.hudWidgetConfig.updateSpace(false);
            this.manageWidget.select(null);
            this.reload();
            Laby.fireEvent((Event)new KeyStrokeUpdateEvent(false));
        })).build().displayInOverlay());
        manageButtonContainer.addEntry((Widget)resetButton);
        this.content.addContent((Widget)manageButtonContainer);
        ((Document)this.document).addChild((Widget)this.content);
    }

    public DivWidget overlayWidget() {
        DivWidget overlay = new DivWidget();
        DivWidget overlayContent = new DivWidget();
        overlayContent.addId("overlay-content");
        ComponentWidget titleAdd = ComponentWidget.i18n((String)"keystrokes.activity.edit.add.title");
        titleAdd.addId("title-add");
        overlayContent.addChild((Widget)titleAdd);
        ComponentWidget titleExit = ComponentWidget.i18n((String)"keystrokes.activity.edit.add.exit");
        titleExit.addId("title-exit");
        overlayContent.addChild((Widget)titleExit);
        overlay.addChild((Widget)overlayContent);
        return overlay;
    }

    public void render(ScreenContext context) {
        if (this.overlayWidget == null || !this.overlayWidget.isVisible()) {
            super.render(context);
            return;
        }
        if (this.content != null) {
            MutableMouse prevMouse = context.mouse();
            try {
                context.setMouse(DUMMY_MOUSE);
                this.content.render(context);
            }
            finally {
                context.setMouse(prevMouse);
            }
        }
        this.overlayWidget.render(context);
    }

    public void onCloseScreen() {
        super.onCloseScreen();
        Laby.fireEvent((Event)new KeyStrokeUpdateEvent(false));
        Laby.references().hudWidgetRegistry().saveConfig();
    }

    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        if (this.overlayWidget == null || !this.overlayWidget.isVisible() || this.addCallback == null || mouseButton == MouseButton.NONE) {
            return super.mouseClicked(mouse, mouseButton);
        }
        float x = 0.0f;
        float y = 0.0f;
        if (this.manageWidget.getMaxX() < this.manageWidget.getMaxY()) {
            x = this.manageWidget.getMaxX() + 2.0f;
        } else {
            y = this.manageWidget.getMaxY() + 2.0f;
        }
        KeyStrokeConfig keyStrokeConfig = new KeyStrokeConfig((Key)mouseButton, x, y);
        this.addCallback.accept(keyStrokeConfig);
        this.overlayWidget.setVisible(false);
        return true;
    }

    public boolean keyPressed(Key key, InputType type) {
        if (this.overlayWidget == null || !this.overlayWidget.isVisible() || this.addCallback == null || key == Key.NONE) {
            return super.keyPressed(key, type);
        }
        if (key != Key.ESCAPE) {
            float x = 0.0f;
            float y = 0.0f;
            if (this.manageWidget.getMaxX() < this.manageWidget.getMaxY()) {
                x = this.manageWidget.getMaxX() + 2.0f;
            } else {
                y = this.manageWidget.getMaxY() + 2.0f;
            }
            KeyStrokeConfig keyStrokeConfig = new KeyStrokeConfig(key, x, y);
            this.addCallback.accept(keyStrokeConfig);
        }
        this.overlayWidget.setVisible(false);
        return true;
    }

    public boolean shouldHandleEscape() {
        return this.overlayWidget != null && this.overlayWidget.isVisible();
    }

    @Subscribe
    public void onKeyStrokeUpdate(KeyStrokeUpdateEvent event) {
        if (event.isRelevantForEditing() && this.manageWidget != null) {
            this.manageWidget.reload();
        }
    }
}

