/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.keystrokes.hudwidget;

import java.util.Set;
import net.labymod.addons.keystrokes.KeyStrokeConfig;
import net.labymod.addons.keystrokes.event.KeyStrokeUpdateEvent;
import net.labymod.addons.keystrokes.hudwidget.KeyStrokesHudWidgetConfig;
import net.labymod.addons.keystrokes.hudwidget.KeyStrokesWidget;
import net.labymod.api.Laby;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.widget.WidgetHudWidget;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.hud.HudWidgetWidget;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.gui.screen.ScreenDisplayEvent;
import net.labymod.api.event.client.input.KeyEvent;
import net.labymod.api.event.client.input.MouseButtonEvent;

public class KeyStrokesHudWidget
extends WidgetHudWidget<KeyStrokesHudWidgetConfig> {
    public KeyStrokesHudWidget() {
        super("keyStrokes", KeyStrokesHudWidgetConfig.class);
    }

    public void load(KeyStrokesHudWidgetConfig config) {
        super.load((HudWidgetConfig)config);
        Set<KeyStrokeConfig> keyStrokes = config.getKeyStrokes();
        if (keyStrokes == null || keyStrokes.isEmpty()) {
            config.setDefaultKeyStrokes();
        }
        config.refreshCPSTracking();
        config.updateSpace(false);
    }

    public void initialize(HudWidgetWidget widget) {
        super.initialize(widget);
        widget.setStencil(false);
        KeyStrokesWidget keyStrokesWidget = new KeyStrokesWidget((KeyStrokesHudWidgetConfig)this.config);
        widget.addChild((Widget)keyStrokesWidget);
    }

    public boolean isVisibleInGame() {
        return true;
    }

    @Subscribe
    public void onKey(KeyEvent event) {
        this.press(event.key(), event.state() != KeyEvent.State.UNPRESSED);
    }

    @Subscribe
    public void onMouseButton(MouseButtonEvent event) {
        this.press((Key)event.button(), event.action() == MouseButtonEvent.Action.CLICK);
    }

    @Subscribe
    public void onKeyStrokeUpdate(KeyStrokeUpdateEvent event) {
        this.requestUpdate("key_stroke_update");
    }

    @Subscribe
    public void onScreenOpen(ScreenDisplayEvent event) {
        if (event.getPreviousScreen() != null) {
            return;
        }
        for (KeyStrokeConfig keyStroke : ((KeyStrokesHudWidgetConfig)this.config).getKeyStrokes()) {
            keyStroke.updatePressed(false);
        }
    }

    private void press(Key key, boolean pressed) {
        if (this.config == null) {
            return;
        }
        if (pressed && !Laby.labyAPI().minecraft().isMouseLocked()) {
            return;
        }
        KeyStrokeConfig keyStroke = ((KeyStrokesHudWidgetConfig)this.config).getKeyStroke(key);
        if (keyStroke == null) {
            return;
        }
        keyStroke.updatePressed(pressed);
    }
}

