/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.keystrokes.widgets;

import net.labymod.addons.keystrokes.KeyStrokeConfig;
import net.labymod.addons.keystrokes.hudwidget.KeyStrokesHudWidgetConfig;
import net.labymod.addons.keystrokes.util.KeyTracker;
import net.labymod.api.Laby;
import net.labymod.api.client.gfx.pipeline.RenderAttributes;
import net.labymod.api.client.gfx.pipeline.RenderAttributesStack;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.state.RoundedData;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.state.states.GuiRectangleRenderState;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.BoundsType;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.util.Color;
import net.labymod.api.util.bounds.Rectangle;
import net.labymod.api.util.color.format.ColorFormat;

public class KeyStrokeWidget
extends SimpleWidget {
    public static final int PADDING = 4;
    private final Key key;
    private final KeyStrokeConfig keyStroke;
    private final KeyStrokesHudWidgetConfig defaultConfig;

    public KeyStrokeWidget(Key key, KeyStrokeConfig keyStroke, KeyStrokesHudWidgetConfig defaultConfig) {
        this.key = key;
        this.keyStroke = keyStroke;
        this.defaultConfig = defaultConfig;
    }

    public void renderWidget(ScreenContext context) {
        boolean renderPressedSeparate;
        super.renderWidget(context);
        Bounds bounds = this.bounds();
        boolean transition = (Boolean)this.defaultConfig.transition().get();
        float transitionProgress = !transition ? 1.0f : this.getTransitionProgress();
        boolean bl = renderPressedSeparate = transitionProgress != 1.0f && transitionProgress != 0.0f;
        int backgroundColor = renderPressedSeparate ? ((Color)this.defaultConfig.backgroundColor().get()).get() : (this.keyStroke.isPressed() ? ((Color)this.defaultConfig.pressedColor().get()).get() : ((Color)this.defaultConfig.backgroundColor().get()).get());
        ScreenCanvas canvas = context.canvas();
        int textColor = this.getTextColor();
        boolean roundedCorners = (Boolean)this.defaultConfig.roundedCorners().get();
        boolean outline = (Boolean)this.defaultConfig.outline().get();
        float borderRadius = 0.0f;
        if (roundedCorners) {
            Float scale = (Float)this.defaultConfig.scale().get();
            float height = this.bounds().getHeight() * scale.floatValue();
            float radius = (float)((Integer)this.defaultConfig.roundedRadius().get()).intValue() * scale.floatValue();
            borderRadius = Math.min(height / 2.0f, radius);
        }
        int outlineColor = !outline || (Boolean)this.defaultConfig.useTextColorAsOutline().get() != false ? textColor : ((Color)this.defaultConfig.outlineColor().get()).get();
        Stack stack = context.stack();
        canvas.submitGuiRect((Rectangle)bounds.rectangle(BoundsType.OUTER), GuiRectangleRenderState.RectConfig.builder().setArgb(backgroundColor).setRoundedData(RoundedData.builder().setRadius(borderRadius).setUpperEdgeSoftness(0.2f).setLowerEdgeSoftness(-0.5f).setBorderColor(outlineColor).setBorderThickness(outline ? 1.0f : 0.0f).build()).build());
        if (renderPressedSeparate) {
            float width = bounds.getWidth() * transitionProgress;
            float height = bounds.getHeight() * transitionProgress;
            float x = bounds.getX() + (bounds.getWidth() - width) / 2.0f;
            float y = bounds.getY() + (bounds.getHeight() - height) / 2.0f;
            Color color = (Color)this.defaultConfig.pressedColor().get();
            canvas.submitGuiRect(x, y, width, height, GuiRectangleRenderState.RectConfig.builder().setArgb(ColorFormat.ARGB32.pack(color.get(), (int)((float)color.getAlpha() * transitionProgress))).setRoundedData(RoundedData.builder().setRadius(roundedCorners ? borderRadius : 0.0f).setUpperEdgeSoftness(0.2f).setLowerEdgeSoftness(-0.5f).setBorderColor(outlineColor).setBorderThickness(outline ? 1.0f : 0.0f).build()).build());
        }
        if (this.key == Key.SPACE && ((Boolean)this.defaultConfig.fancySpace().get()).booleanValue()) {
            float spaceWidth = bounds.getWidth() / 2.0f / 2.0f;
            RenderAttributesStack renderAttributesStack = Laby.references().renderEnvironmentContext().renderAttributesStack();
            RenderAttributes attributes = renderAttributesStack.last();
            canvas.submitGuiRect(bounds.getCenterX() - spaceWidth, bounds.getY() + 5.0f, spaceWidth * 2.0f, attributes.isForceVanillaFont() ? 1.0f : 1.5f, GuiRectangleRenderState.RectConfig.builder().setArgb(textColor).setRoundedData(RoundedData.builder().setRadius(attributes.isForceVanillaFont() ? 0.0f : 1.0f).setUpperEdgeSoftness(0.2f).setLowerEdgeSoftness(-0.5f).build()).build());
            return;
        }
        KeyTracker keyTracker = this.keyStroke.getKeyTracker();
        float fontHeight = canvas.getLineHeight();
        float y = bounds.getCenterY() - fontHeight / 2.0f + 0.8f;
        if (keyTracker != null) {
            y -= fontHeight * 0.25f;
        }
        float x = bounds.getCenterX() + 0.4f;
        canvas.submitText(this.keyStroke.getKeyName(), x, y, textColor, 1.0f, 7);
        if (keyTracker != null) {
            stack.push();
            stack.translate(x, y, 0.0f);
            stack.scale(0.5f);
            canvas.submitText(keyTracker.getCount() + " CPS", 0.0f, fontHeight * 1.5f + 3.0f, textColor, 1.0f, 7);
            stack.pop();
        }
    }

    private int getBackgroundColor() {
        boolean pressed = this.keyStroke.isPressed();
        if (pressed) {
            return ((Color)this.defaultConfig.pressedColor().get()).get();
        }
        return ((Color)this.defaultConfig.backgroundColor().get()).get();
    }

    private int getTextColor() {
        return ((Color)this.defaultConfig.textColor().get()).get();
    }

    public Key key() {
        return this.key;
    }

    public KeyStrokeConfig config() {
        return this.keyStroke;
    }

    private float getTransitionProgress() {
        long timeElapsed = System.currentTimeMillis() - this.keyStroke.getLastPressedUpdate();
        if (timeElapsed > 100L) {
            return 1.0f;
        }
        if (!this.keyStroke.isPressed()) {
            return 1.0f - (float)timeElapsed / 100.0f;
        }
        return (float)timeElapsed / 100.0f;
    }
}

