/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.keystrokes.hudwidget;

import java.util.HashSet;
import java.util.Set;
import net.labymod.addons.keystrokes.KeyStrokeConfig;
import net.labymod.addons.keystrokes.activities.KeyStrokeManageActivity;
import net.labymod.api.Laby;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.widget.widgets.activity.settings.ActivitySettingWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.color.ColorPickerWidget;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.configuration.settings.annotation.SettingRequires;
import net.labymod.api.util.Color;
import net.labymod.api.util.MethodOrder;

public class KeyStrokesHudWidgetConfig
extends HudWidgetConfig {
    @ColorPickerWidget.ColorPickerSetting(chroma=true, alpha=true)
    private final ConfigProperty<Color> textColor = new ConfigProperty((Object)Color.ofRGB((int)255, (int)255, (int)255, (int)255));
    @ColorPickerWidget.ColorPickerSetting(chroma=true, alpha=true)
    private final ConfigProperty<Color> backgroundColor = new ConfigProperty((Object)Color.ofRGB((int)0, (int)0, (int)0, (int)155));
    @ColorPickerWidget.ColorPickerSetting(chroma=true, alpha=true)
    private final ConfigProperty<Color> pressedColor = new ConfigProperty((Object)Color.ofRGB((int)255, (int)255, (int)255, (int)104));
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> outline = new ConfigProperty((Object)false);
    @SwitchWidget.SwitchSetting
    @SettingRequires(value="outline")
    private final ConfigProperty<Boolean> useTextColorAsOutline = new ConfigProperty((Object)true);
    @ColorPickerWidget.ColorPickerSetting(chroma=true, alpha=true)
    @SettingRequires(value="useTextColorAsOutline", invert=true)
    private final ConfigProperty<Color> outlineColor = new ConfigProperty((Object)Color.ofRGB((int)255, (int)255, (int)255, (int)255));
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> roundedCorners = new ConfigProperty((Object)Laby.labyAPI().themeService().currentTheme().getId().equals("fancy"));
    @SliderWidget.SliderSetting(min=1.0f, max=10.0f, steps=1.0f)
    @SettingRequires(value="roundedCorners")
    private final ConfigProperty<Integer> roundedRadius = new ConfigProperty((Object)5);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> transition = new ConfigProperty((Object)true);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> fancySpace = (ConfigProperty)new ConfigProperty((Object)true).addChangeListener(this::updateFancySpace);
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> bigSpace = (ConfigProperty)new ConfigProperty((Object)false).addChangeListener(bigSpace -> this.updateSpace(true));
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> trackMouseCPS = (ConfigProperty)new ConfigProperty((Object)true).addChangeListener((property, oldValue, newValue) -> this.refreshCPSTracking());
    private final ConfigProperty<Set<KeyStrokeConfig>> keyStrokes = ConfigProperty.create(new HashSet());
    private final ConfigProperty<Key> base = new ConfigProperty((Object)Key.S);

    public Set<KeyStrokeConfig> getKeyStrokes() {
        return (Set)this.keyStrokes.get();
    }

    @MethodOrder(before="pressedColor")
    @ActivitySettingWidget.ActivitySetting
    public Activity edit() {
        return new KeyStrokeManageActivity(this);
    }

    public ConfigProperty<Color> pressedColor() {
        return this.pressedColor;
    }

    public ConfigProperty<Color> textColor() {
        return this.textColor;
    }

    public ConfigProperty<Color> backgroundColor() {
        return this.backgroundColor;
    }

    public ConfigProperty<Boolean> outline() {
        return this.outline;
    }

    public ConfigProperty<Boolean> useTextColorAsOutline() {
        return this.useTextColorAsOutline;
    }

    public ConfigProperty<Color> outlineColor() {
        return this.outlineColor;
    }

    public ConfigProperty<Boolean> roundedCorners() {
        return this.roundedCorners;
    }

    public ConfigProperty<Integer> roundedRadius() {
        return this.roundedRadius;
    }

    public ConfigProperty<Boolean> transition() {
        return this.transition;
    }

    public ConfigProperty<Boolean> fancySpace() {
        return this.fancySpace;
    }

    public ConfigProperty<Boolean> bigSpace() {
        return this.bigSpace;
    }

    public ConfigProperty<Boolean> trackMouseCPS() {
        return this.trackMouseCPS;
    }

    public void setDefaultKeyStrokes() {
        HashSet<KeyStrokeConfig> keyStrokes = new HashSet<KeyStrokeConfig>();
        keyStrokes.add(new KeyStrokeConfig(Key.W, 0.0f, -22.0f));
        keyStrokes.add(new KeyStrokeConfig(Key.A, -22.0f, 0.0f));
        keyStrokes.add(new KeyStrokeConfig(Key.S, 22.0f, 22.0f));
        keyStrokes.add(new KeyStrokeConfig(Key.D, 22.0f, 0.0f));
        KeyStrokeConfig spaceConfig = new KeyStrokeConfig(Key.SPACE, -22.0f, 22.0f);
        keyStrokes.add(spaceConfig);
        keyStrokes.add(new KeyStrokeConfig(MouseButton.LEFT, -22.0f, 44.0f));
        keyStrokes.add(new KeyStrokeConfig(MouseButton.RIGHT, 11.0f, 44.0f));
        if (this.base.get() != Key.S) {
            this.base.reset();
        }
        if (!((Boolean)this.bigSpace.get()).booleanValue()) {
            spaceConfig.updateWidth(spaceConfig.key());
            spaceConfig.updatePosition(10.0f - spaceConfig.getWidth() / 2.0f, spaceConfig.getY());
        }
        this.keyStrokes.set(keyStrokes);
        if (((Boolean)this.fancySpace.get()).booleanValue()) {
            this.updateFancySpace((Boolean)this.fancySpace.get());
        }
    }

    public KeyStrokeConfig anchorConfig() {
        return this.getKeyStroke((Key)this.base.get());
    }

    public KeyStrokeConfig getKeyStroke(Key key) {
        for (KeyStrokeConfig keyStroke : this.getKeyStrokes()) {
            if (keyStroke.key() != key) continue;
            return keyStroke;
        }
        return null;
    }

    public ConfigProperty<Key> base() {
        return this.base;
    }

    public boolean addKeyStroke(KeyStrokeConfig keyStrokeConfig) {
        if (this.getKeyStroke(keyStrokeConfig.key()) != null) {
            return false;
        }
        ((Set)this.keyStrokes.get()).add(keyStrokeConfig);
        return true;
    }

    public boolean removeKeyStroke(KeyStrokeConfig keyStrokeConfig) {
        return ((Set)this.keyStrokes.get()).remove(keyStrokeConfig);
    }

    public void refreshCPSTracking() {
        boolean tracking = (Boolean)this.trackMouseCPS.get();
        for (KeyStrokeConfig keyStrokeConfig : (Set)this.keyStrokes.get()) {
            if (tracking) {
                keyStrokeConfig.enableKeyTracking();
                continue;
            }
            keyStrokeConfig.disableKeyTracking();
        }
    }

    public void updateSpace(boolean actuallyUpdate) {
        for (KeyStrokeConfig keyStrokeConfig : (Set)this.keyStrokes.get()) {
            if (keyStrokeConfig.key() != Key.SPACE) continue;
            if (!actuallyUpdate) {
                keyStrokeConfig.updateBigSpace((Boolean)this.bigSpace.get());
                continue;
            }
            float prevWidth = keyStrokeConfig.getWidth();
            keyStrokeConfig.updateBigSpace((Boolean)this.bigSpace.get());
            float newWidth = keyStrokeConfig.getWidth();
            float centerX = keyStrokeConfig.getX() + prevWidth / 2.0f;
            float targetX = centerX - newWidth / 2.0f;
            keyStrokeConfig.updatePosition(targetX, keyStrokeConfig.getY());
        }
    }

    public void updateFancySpace(boolean fancy) {
        KeyStrokeConfig space = this.getKeyStroke(Key.SPACE);
        if (space == null) {
            return;
        }
        float prevHeight = space.getHeight(!fancy);
        float newHeight = space.getHeight(fancy);
        float bigHeight = fancy ? prevHeight : newHeight;
        float smallHeight = fancy ? newHeight : prevHeight;
        float targetY = space.getY() + 4.0f + bigHeight;
        float targetMaxX = space.getX() + space.getWidth();
        Key base = (Key)this.base().get();
        for (KeyStrokeConfig keyStrokeConfig : (Set)this.keyStrokes.get()) {
            boolean inWidth;
            float y = keyStrokeConfig.getY();
            if (keyStrokeConfig.key() == base || keyStrokeConfig.key() == Key.SPACE || y < space.getY()) continue;
            float x = keyStrokeConfig.getX();
            float maxX = x + keyStrokeConfig.getWidth();
            boolean bl = inWidth = x >= space.getX() && x <= targetMaxX || maxX >= space.getX() && maxX <= targetMaxX;
            if (!(y < targetY) || !inWidth) continue;
            if (fancy) {
                keyStrokeConfig.updatePosition(x, y - bigHeight + smallHeight);
                continue;
            }
            keyStrokeConfig.updatePosition(x, y - smallHeight + bigHeight);
        }
    }
}

