/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.keystrokes.activities;

import java.awt.Color;
import java.util.function.Consumer;
import net.labymod.addons.keystrokes.KeyStrokeConfig;
import net.labymod.addons.keystrokes.event.KeyStrokeUpdateEvent;
import net.labymod.addons.keystrokes.hudwidget.KeyStrokesHudWidgetConfig;
import net.labymod.addons.keystrokes.util.AnchorController;
import net.labymod.addons.keystrokes.widgets.KeyStrokeGridWidget;
import net.labymod.addons.keystrokes.widgets.KeyStrokeWidget;
import net.labymod.api.Laby;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.gui.HorizontalAlignment;
import net.labymod.api.client.gui.VerticalAlignment;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.KeyHandler;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.state.states.GuiRectangleRenderState;
import net.labymod.api.client.gui.screen.widget.AbstractWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.render.font.FontSize;
import net.labymod.api.event.Event;
import net.labymod.api.util.I18n;
import net.labymod.api.util.bounds.Point;
import net.labymod.api.util.bounds.Rectangle;

@AutoWidget
public class KeyStrokeManageWidget
extends KeyStrokeGridWidget {
    private static final AnchorController CONTROLLER = new AnchorController();
    private static final Key CLICK_KEY = MouseButton.LEFT;
    private static final long DRAGGING_DELAY = 100L;
    private final Consumer<KeyStrokeConfig> selectConsumer;
    private final String disableDocking;
    private final String disabledDocking;
    private KeyStrokeWidget selected;
    private long draggingStartTime;
    private float offsetX;
    private float offsetY;

    protected KeyStrokeManageWidget(KeyStrokesHudWidgetConfig config, Consumer<KeyStrokeConfig> selectConsumer) {
        super(config);
        this.selectConsumer = selectConsumer;
        this.disableDocking = I18n.translate((String)"keystrokes.activity.edit.docking.disable", (Object[])new Object[0]);
        this.disabledDocking = I18n.translate((String)"keystrokes.activity.edit.docking.disabled", (Object[])new Object[0]);
    }

    @Override
    public void initialize(Parent parent) {
        super.initialize(parent);
        this.updateWidgetBounds((Rectangle)this.bounds());
    }

    public void renderWidget(ScreenContext context) {
        if (this.selected == null) {
            super.renderWidget(context);
            return;
        }
        if (this.draggingStartTime == -1L || this.draggingStartTime + 100L > System.currentTimeMillis()) {
            super.renderWidget(context);
            this.highlightSelected(context);
            return;
        }
        super.renderDebug(context);
        for (Widget child : this.children) {
            if (child == this.selected) continue;
            child.render(context);
        }
        MutableMouse mouse = context.mouse();
        Bounds parentBounds = this.bounds();
        Bounds bounds = this.selected.bounds();
        float width = bounds.getWidth();
        float x = (float)mouse.getX() - this.offsetX;
        if (x < parentBounds.getX()) {
            x = parentBounds.getX();
        } else if (x + width > parentBounds.getMaxX()) {
            x = parentBounds.getMaxX() - width;
        }
        float height = bounds.getHeight();
        float y = (float)mouse.getY() - this.offsetY;
        if (y < parentBounds.getY()) {
            y = parentBounds.getY();
        } else if (y + height > parentBounds.getMaxY()) {
            y = parentBounds.getMaxY() - height;
        }
        AnchorController.Anchor anchor = CONTROLLER.updateAnchor(this.children, this.selected, x, y, width, height);
        this.highlightAnchor(context, anchor);
        bounds.setOuterPosition(x, y, REASON);
        this.selected.render(context);
        this.highlightSelected(context);
        String infoText = KeyHandler.isControlDown() ? this.disabledDocking : this.disableDocking;
        context.canvas().submitText(infoText, this.bounds().getCenterX(), this.bounds().getMaxY() - 10.0f, NamedTextColor.GRAY.getValue(), FontSize.PredefinedFontSize.SMALL, 3);
    }

    public boolean mouseClicked(MutableMouse mouse, MouseButton button) {
        if (button != CLICK_KEY) {
            return false;
        }
        KeyStrokeWidget clicked = (KeyStrokeWidget)this.findFirstChildIf(AbstractWidget::isHovered);
        if (this.selected == null && clicked == null) {
            return false;
        }
        this.selected = clicked;
        this.selectConsumer.accept(clicked == null ? null : clicked.config());
        if (clicked == null) {
            return false;
        }
        this.offsetX = (float)mouse.getX() - this.selected.bounds().getX();
        this.offsetY = (float)mouse.getY() - this.selected.bounds().getY();
        this.draggingStartTime = System.currentTimeMillis();
        return true;
    }

    public boolean mouseReleased(MutableMouse mouse, MouseButton mouseButton) {
        if (this.selected == null || this.draggingStartTime == -1L) {
            return false;
        }
        long dragStartTime = this.draggingStartTime;
        this.draggingStartTime = -1L;
        if (System.currentTimeMillis() < dragStartTime + 100L) {
            return true;
        }
        AnchorController.Anchor anchor = CONTROLLER.anchor();
        if (anchor.isValid()) {
            Bounds bounds = this.selected.bounds();
            Bounds anchorBounds = anchor.getWidget().bounds();
            float x = 0.0f;
            float y = 0.0f;
            HorizontalAlignment horizontalSide = anchor.getHorizontalSide();
            if (horizontalSide == HorizontalAlignment.LEFT) {
                x -= bounds.getWidth() + 2.0f;
            } else if (horizontalSide == HorizontalAlignment.RIGHT) {
                x += anchorBounds.getWidth() + 2.0f;
            }
            VerticalAlignment verticalSide = anchor.getVerticalSide();
            if (verticalSide == VerticalAlignment.TOP) {
                y -= bounds.getHeight() + 2.0f;
            } else if (verticalSide == VerticalAlignment.BOTTOM) {
                y += anchorBounds.getHeight() + 2.0f;
            }
            bounds.setOuterPosition(anchorBounds.getX() + x, anchorBounds.getY() + y, REASON);
        }
        if (this.updateKeyStrokePosition(this.selected)) {
            this.updateSize();
            Laby.fireEvent((Event)new KeyStrokeUpdateEvent(false));
        }
        return true;
    }

    public void onBoundsChanged(Rectangle previousRect, Rectangle newRect) {
        this.updateWidgetBounds(newRect);
    }

    @Override
    protected void updateWidgetBounds(Rectangle bounds) {
        this.updateWidgetBounds(Point.fixed((int)((int)bounds.getCenterX()), (int)((int)bounds.getCenterY())), false, true);
    }

    @Override
    public void reload() {
        super.reload();
        this.updateWidgetBounds((Rectangle)this.bounds());
    }

    private void highlightAnchor(ScreenContext context, AnchorController.Anchor anchor) {
        if (!anchor.isValid()) {
            return;
        }
        ScreenCanvas canvas = context.canvas();
        Bounds bounds = anchor.getWidget().bounds();
        HorizontalAlignment horizontalSide = anchor.getHorizontalSide();
        if (horizontalSide == HorizontalAlignment.LEFT) {
            canvas.submitGuiRect((Rectangle)Rectangle.absolute((float)(bounds.getX() - 1.0f), (float)bounds.getY(), (float)bounds.getX(), (float)bounds.getMaxY()), GuiRectangleRenderState.RectConfig.builder().setArgb(Color.WHITE.getRGB()).build());
        } else if (horizontalSide == HorizontalAlignment.RIGHT) {
            canvas.submitGuiRect((Rectangle)Rectangle.absolute((float)bounds.getMaxX(), (float)bounds.getY(), (float)(bounds.getMaxX() + 1.0f), (float)bounds.getMaxY()), GuiRectangleRenderState.RectConfig.builder().setArgb(Color.WHITE.getRGB()).build());
        }
        VerticalAlignment verticalSide = anchor.getVerticalSide();
        if (verticalSide == VerticalAlignment.TOP) {
            canvas.submitGuiRect((Rectangle)Rectangle.absolute((float)bounds.getX(), (float)(bounds.getY() - 1.0f), (float)bounds.getMaxX(), (float)bounds.getY()), GuiRectangleRenderState.RectConfig.builder().setArgb(Color.WHITE.getRGB()).build());
        } else if (verticalSide == VerticalAlignment.BOTTOM) {
            canvas.submitGuiRect((Rectangle)Rectangle.absolute((float)bounds.getX(), (float)bounds.getMaxY(), (float)bounds.getMaxX(), (float)(bounds.getMaxY() + 1.0f)), GuiRectangleRenderState.RectConfig.builder().setArgb(Color.WHITE.getRGB()).build());
        }
    }

    private void highlightSelected(ScreenContext context) {
        Bounds parentBounds = this.bounds();
        Bounds bounds = this.selected.bounds();
        ScreenCanvas canvas = context.canvas();
        canvas.submitGuiRect(parentBounds.getX(), bounds.getCenterY() - 0.5f, bounds.getX() - parentBounds.getX(), 1.0f, GuiRectangleRenderState.RectConfig.builder().setArgb(Color.GRAY.getRGB()).build());
        canvas.submitGuiRect(bounds.getCenterX() - 0.5f, parentBounds.getY(), 1.0f, bounds.getY() - parentBounds.getY(), GuiRectangleRenderState.RectConfig.builder().setArgb(Color.GRAY.getRGB()).build());
        canvas.submitGuiRect(bounds.getMaxX(), bounds.getCenterY() - 0.5f, parentBounds.getMaxX() - bounds.getMaxX(), 1.0f, GuiRectangleRenderState.RectConfig.builder().setArgb(Color.GRAY.getRGB()).build());
        canvas.submitGuiRect(bounds.getCenterX() - 0.5f, bounds.getMaxY(), 1.0f, parentBounds.getMaxY() - bounds.getMaxY(), GuiRectangleRenderState.RectConfig.builder().setArgb(Color.GRAY.getRGB()).build());
    }

    private boolean updateKeyStrokePosition(KeyStrokeWidget widget) {
        Key anchorKey;
        Bounds keyStrokeBounds = widget.bounds();
        float x = keyStrokeBounds.getX();
        float y = keyStrokeBounds.getY();
        KeyStrokeConfig config = widget.config();
        Key key = config.key();
        if (key == (anchorKey = (Key)this.config.base().get())) {
            return this.updateAnchorPosition(config, x, y);
        }
        KeyStrokeConfig anchorConfig = this.config.getKeyStroke(anchorKey);
        Widget anchor = this.findFirstChildIf(child -> child.config() == anchorConfig);
        if (anchor == null) {
            return false;
        }
        Bounds anchorBounds = anchor.bounds();
        float anchorX = anchorBounds.getX();
        float anchorY = anchorBounds.getY();
        float newX = x - anchorX;
        float newY = y - anchorY;
        if (config.getX() == newX && config.getY() == newY) {
            return false;
        }
        config.updatePosition(newX, newY);
        return true;
    }

    private boolean updateAnchorPosition(KeyStrokeConfig anchor, float x, float y) {
        KeyStrokeWidget childWidget = (KeyStrokeWidget)this.findFirstChildIf(child -> child.config() != anchor);
        if (childWidget == null) {
            anchor.updatePosition(0.0f, 0.0f);
            return true;
        }
        Bounds childBounds = childWidget.bounds();
        float childX = childBounds.getX();
        float childY = childBounds.getY();
        float diffX = x - childX + childWidget.config().getX();
        float diffY = y - childY + childWidget.config().getY();
        float newX = anchor.getX() + diffX;
        float newY = anchor.getY() + diffY;
        if (anchor.getX() == newX && anchor.getY() == newY) {
            return false;
        }
        anchor.updatePosition(newX, newY);
        for (KeyStrokeConfig keyStroke : this.config.getKeyStrokes()) {
            if (keyStroke == anchor) continue;
            keyStroke.updatePosition(keyStroke.getX() - diffX, keyStroke.getY() - diffY);
        }
        return true;
    }

    public void updateSize() {
        float minX = 0.0f;
        float minY = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        KeyStrokeConfig anchorConfig = null;
        Key key = (Key)this.config.base().get();
        for (KeyStrokeConfig keyStrokeConfig : this.config.getKeyStrokes()) {
            if (keyStrokeConfig.key() == key) {
                anchorConfig = keyStrokeConfig;
                continue;
            }
            if (minX > keyStrokeConfig.getX()) {
                minX = keyStrokeConfig.getX();
            }
            if (minY > keyStrokeConfig.getY()) {
                minY = keyStrokeConfig.getY();
            }
            if (maxX < keyStrokeConfig.getX()) {
                maxX = keyStrokeConfig.getX();
            }
            if (!(maxY < keyStrokeConfig.getY())) continue;
            maxY = keyStrokeConfig.getY();
        }
        if (anchorConfig == null) {
            return;
        }
        anchorConfig.updatePosition(-minX, -minY);
    }

    public void select(KeyStrokeConfig keyStrokeConfig) {
        if (keyStrokeConfig == null) {
            this.selected = null;
            return;
        }
        KeyStrokeWidget keyStrokeWidget = (KeyStrokeWidget)this.findFirstChildIf(child -> child.config() == keyStrokeConfig);
        if (keyStrokeWidget != null) {
            this.selected = keyStrokeWidget;
            this.draggingStartTime = -1L;
        }
    }
}

