/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.version.VersionInterval;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.labymod.addons.labyfabric.loader.LabyFabricLoader;
import net.labymod.api.mapping.MappingService;
import net.labymod.api.mapping.MixinRemapperInjector;
import net.labymod.api.mapping.provider.MappingProvider;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IRemapper;
import org.spongepowered.asm.mixin.transformer.Config;

public final class FabricMixinBootstrap {
    private static boolean initialized = false;

    private FabricMixinBootstrap() {
    }

    public static void init(LabyFabricLoader loader, MappingProvider mappings) {
        if (initialized) {
            throw new RuntimeException("FabricMixinBootstrap has already been initialized!");
        }
        IRemapper remapper = MappingService.instance().mixinRemapper(mappings);
        MixinRemapperInjector.instance().injectRemapper(remapper);
        HashMap<String, ModContainer> configToModMap = new HashMap<String, ModContainer>();
        for (ModContainer mod : loader.getAllMods()) {
            for (String config : ((LoaderModMetadata)mod.getMetadata()).getMixinConfigs(EnvType.CLIENT)) {
                ModContainer prev = configToModMap.putIfAbsent(config, mod);
                if (prev != null) {
                    throw new RuntimeException(String.format("Non-unique Mixin config name %s used by the mods %s and %s", config, prev.getMetadata().getId(), mod.getMetadata().getId()));
                }
                try {
                    Mixins.addConfiguration((String)config);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(String.format("Error parsing or using Mixin config %s for mod %s", config, mod.getMetadata().getId()), throwable);
                }
            }
        }
        MixinConfigDecorator.apply(configToModMap);
        FabricLauncherBase.finishMixinBootstrapping();
        initialized = true;
    }

    private static final class MixinConfigDecorator {
        private static final List<LoaderMixinVersionEntry> versions = new ArrayList<LoaderMixinVersionEntry>();

        private MixinConfigDecorator() {
        }

        static void apply(Map<String, ModContainer> configToModMap) {
            for (Config rawConfig : Mixins.getConfigs()) {
                ModContainer mod = configToModMap.get(rawConfig.getName());
                if (mod == null) continue;
                IMixinConfig config = rawConfig.getConfig();
                config.decorate("fabric-modId", (Object)mod.getMetadata().getId());
                config.decorate("fabric-compat", (Object)MixinConfigDecorator.getMixinCompat(mod));
            }
        }

        private static int getMixinCompat(ModContainer mod) {
            List<VersionInterval> reqIntervals = Collections.singletonList(VersionInterval.INFINITE);
            for (ModDependency dep : mod.getMetadata().getDependencies()) {
                if (!dep.getModId().equals("fabricloader") && !dep.getModId().equals("fabric-loader")) continue;
                if (dep.getKind() == ModDependency.Kind.DEPENDS) {
                    reqIntervals = VersionInterval.and(reqIntervals, dep.getVersionIntervals());
                    continue;
                }
                if (dep.getKind() != ModDependency.Kind.BREAKS) continue;
                reqIntervals = VersionInterval.and(reqIntervals, VersionInterval.not(dep.getVersionIntervals()));
            }
            if (reqIntervals.isEmpty()) {
                throw new IllegalStateException("mod " + String.valueOf(mod) + " is incompatible with every loader version?");
            }
            Version minLoaderVersion = reqIntervals.get(0).getMin();
            if (minLoaderVersion != null) {
                for (LoaderMixinVersionEntry version : versions) {
                    if (minLoaderVersion.compareTo(version.loaderVersion) < 0) continue;
                    return version.mixinVersion;
                }
            }
            return 9002;
        }

        private static void addVersion(String minLoaderVersion, int mixinCompat) {
            try {
                versions.add(new LoaderMixinVersionEntry(SemanticVersion.parse(minLoaderVersion), mixinCompat));
            }
            catch (VersionParsingException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            MixinConfigDecorator.addVersion("0.16.0", 14000);
            MixinConfigDecorator.addVersion("0.12.0-", 10000);
        }

        private static final class LoaderMixinVersionEntry {
            final SemanticVersion loaderVersion;
            final int mixinVersion;

            LoaderMixinVersionEntry(SemanticVersion loaderVersion, int mixinVersion) {
                this.loaderVersion = loaderVersion;
                this.mixinVersion = mixinVersion;
            }
        }
    }
}

