/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric.launch;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.util.LoaderUtil;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.core.loader.DefaultLabyModLoader;
import net.minecraft.launchwrapper.Launch;

public class LabyFabricLauncher
extends FabricLauncherBase {
    private static final String MINECRAFT_MAIN_CLASS = "net.minecraft.client.main.Main";

    @Override
    public void addToClassPath(Path path, String ... allowedPrefixes) {
        PlatformEnvironment.getPlatformClassloader().addPath(path);
    }

    @Override
    public void setAllowedPrefixes(Path path, String ... prefixes) {
    }

    @Override
    public void setValidParentClassPath(Collection<Path> paths) {
    }

    @Override
    public EnvType getEnvironmentType() {
        return EnvType.CLIENT;
    }

    @Override
    public boolean isClassLoaded(String name) {
        return false;
    }

    @Override
    public Class<?> loadIntoTarget(String name) throws ClassNotFoundException {
        return PlatformEnvironment.getPlatformClassloader().findClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return PlatformEnvironment.getPlatformClassloader().getPlatformClassloader().getResourceAsStream(name);
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return PlatformEnvironment.getPlatformClassloader().getPlatformClassloader();
    }

    @Override
    public byte[] getClassByteArray(String name, boolean runTransformers) throws IOException {
        return DefaultLabyModLoader.getInstance().getMixinServiceClassBytes(name, name, null);
    }

    @Override
    public Manifest getManifest(Path originPath) {
        return null;
    }

    @Override
    public boolean isDevelopment() {
        return DefaultLabyModLoader.getInstance().isLabyModDevelopmentEnvironment();
    }

    @Override
    public String getEntrypoint() {
        return MINECRAFT_MAIN_CLASS;
    }

    @Override
    public String getTargetNamespace() {
        return this.isDevelopment() ? "named" : "official";
    }

    @Override
    public List<Path> getClassPath() {
        ArrayList<Path> classPath = new ArrayList<Path>();
        for (URL url : Launch.classLoader.getSources()) {
            Path path;
            try {
                path = Paths.get(url.toURI());
            }
            catch (Exception exception) {
                path = Paths.get(url.getPath(), new String[0]);
            }
            if (!Files.exists(path, new LinkOption[0]) || path.equals(path.getRoot())) continue;
            classPath.add(LoaderUtil.normalizeExistingPath(path));
        }
        return classPath;
    }
}

