/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric.loader.transformer;

import net.fabricmc.api.EnvType;
import net.fabricmc.classtweaker.api.ClassTweaker;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.transformer.ClassStripper;
import net.fabricmc.loader.impl.transformer.EnvironmentStrippingData;
import net.fabricmc.loader.impl.transformer.PackageAccessFixer;
import net.labymod.api.loader.platform.PlatformClassTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.spongepowered.asm.util.asm.ASM;

public class FabricTransformer
implements PlatformClassTransformer,
IClassTransformer {
    private final FabricLoader loader;
    private final ClassTweaker tweaker;

    public FabricTransformer(FabricLoader loader, ClassTweaker tweaker) {
        this.loader = loader;
        this.tweaker = tweaker;
    }

    public int getPriority() {
        return 1001;
    }

    public byte[] transform(String name, String transformedName, byte ... classData) {
        ClassWriter classWriter;
        boolean applyAccessWidener;
        boolean internalClass = name.startsWith("net.labymod") || name.startsWith("net.fabricmc.loader") || name.startsWith("net.fabricmc.api");
        boolean minecraftClass = name.startsWith("net.minecraft.") || name.startsWith("com.mojang.blaze3d.") || name.indexOf(46) < 0;
        boolean environmentStrip = !minecraftClass || this.loader.isDevelopmentEnvironment();
        boolean bl = applyAccessWidener = minecraftClass && this.tweaker.getTargets().contains(name);
        if (classData == null || internalClass) {
            return classData;
        }
        ClassReader classReader = new ClassReader(classData);
        Object visitor = classWriter = new ClassWriter(classReader, 0);
        int visitorCount = 0;
        if (applyAccessWidener) {
            visitor = this.tweaker.createClassVisitor(ASM.API_VERSION, (ClassVisitor)visitor, null);
            ++visitorCount;
        }
        if (minecraftClass) {
            visitor = new PackageAccessFixer(ASM.API_VERSION, (ClassVisitor)visitor);
            ++visitorCount;
        }
        if (environmentStrip) {
            EnvironmentStrippingData stripData = new EnvironmentStrippingData(ASM.API_VERSION, EnvType.CLIENT.toString());
            classReader.accept((ClassVisitor)stripData, 5);
            if (stripData.stripEntireClass()) {
                throw new RuntimeException("Cannot load class " + name + " in environment type " + String.valueOf((Object)EnvType.CLIENT));
            }
            if (!stripData.isEmpty()) {
                visitor = new ClassStripper(ASM.API_VERSION, (ClassVisitor)visitor, stripData.getStripInterfaces(), stripData.getStripFields(), stripData.getStripMethods());
                ++visitorCount;
            }
        }
        if (visitorCount <= 0) {
            return classData;
        }
        classReader.accept((ClassVisitor)visitor, 0);
        return classWriter.toByteArray();
    }
}

