/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch;

import java.lang.reflect.Method;
import java.util.Map;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.launch.MappingConfiguration;
import org.spongepowered.asm.mixin.MixinEnvironment;

public abstract class FabricLauncherBase
implements FabricLauncher {
    private static final MappingConfiguration mappingConfiguration = new MappingConfiguration();
    private static boolean mixinReady;
    private static Map<String, Object> properties;
    private static FabricLauncher launcher;

    protected FabricLauncherBase() {
        FabricLauncherBase.setLauncher(this);
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, FabricLauncherBase.getLauncher().getTargetClassLoader());
    }

    public static FabricLauncher getLauncher() {
        return launcher;
    }

    private static void setLauncher(FabricLauncher launcherA) {
        if (launcher != null && launcher != launcherA) {
            throw new RuntimeException("Duplicate setLauncher call!");
        }
        launcher = launcherA;
    }

    public static Map<String, Object> getProperties() {
        return properties;
    }

    protected static void setProperties(Map<String, Object> propertiesA) {
        if (properties != null && properties != propertiesA) {
            throw new RuntimeException("Duplicate setProperties call!");
        }
        properties = propertiesA;
    }

    public static void finishMixinBootstrapping() {
        if (mixinReady) {
            throw new RuntimeException("Must not call FabricLauncherBase.finishMixinBootstrapping() twice!");
        }
        try {
            Method m = MixinEnvironment.class.getDeclaredMethod("gotoPhase", MixinEnvironment.Phase.class);
            m.setAccessible(true);
            m.invoke(null, MixinEnvironment.Phase.INIT);
            m.invoke(null, MixinEnvironment.Phase.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        mixinReady = true;
    }

    public static boolean isMixinReady() {
        return mixinReady;
    }

    @Override
    public MappingConfiguration getMappingConfiguration() {
        return mappingConfiguration;
    }
}

