/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.labymod.api.Constants;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.models.version.Version;
import net.labymod.api.util.version.SemanticVersion;
import net.labymod.core.loader.DefaultLabyModLoader;

public interface FabricConstants {
    public static final String LOADER_MOD_ID = "fabricloader";
    public static final Version LOADER_VERSION = new SemanticVersion("0.18.1");
    public static final String INTERMEDIARY_MAPPINGS_PATH = String.valueOf(Constants.Files.MAPPINGS) + "/%s-intermediary.tiny";
    public static final Path FABRIC_DIRECTORY = FabricConstants.fromArguments("net.labymod.fabric-dir", DefaultLabyModLoader.getInstance().getGameDirectory().resolve("labymod-neo").resolve("fabric"));
    public static final String FABRIC_VERSION_PATH = String.valueOf(FABRIC_DIRECTORY) + "/%s";
    public static final String TEMP_MAPPINGS_PATH = FABRIC_VERSION_PATH + "/temp-mappings.tiny";
    public static final String MODS_DIRECTORY_PATH = FABRIC_VERSION_PATH + "/mods";
    public static final String CONFIG_DIRECTORY_PATH = FABRIC_VERSION_PATH + "/config";
    public static final String MOD_REMAP_DIRECTORY_PATH = FABRIC_VERSION_PATH + "/remap";
    public static final String MOD_REMAP_INPUT_DIRECTORY_PATH = MOD_REMAP_DIRECTORY_PATH + "/input";
    public static final String MAP_REMAP_VERSION_PATH = MOD_REMAP_DIRECTORY_PATH + "/remap.version";
    public static final int REMAP_VERSION = 2;

    public static Path versionedPath(String path) {
        return FabricConstants.versionedPath(path, PlatformEnvironment.getRunningVersion());
    }

    public static Path versionedPath(String path, String version) {
        return Paths.get(String.format(path, version), new String[0]);
    }

    private static Path fromArguments(String argument, Path fallback) {
        String path = System.getProperty(argument);
        if (path == null) {
            return fallback;
        }
        return Paths.get(path, new String[0]);
    }
}

