/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.fabricmc.classtweaker.api.ClassTweaker;
import net.fabricmc.classtweaker.api.ClassTweakerReader;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.classtweaker.visitors.ClassTweakerRemapperVisitor;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.impl.FormattedException;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.fabricmc.loader.impl.game.minecraft.patch.EntrypointPatch;
import net.fabricmc.loader.impl.launch.FabricMixinBootstrap;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.labymod.addons.labyfabric.FabricConstants;
import net.labymod.addons.labyfabric.launch.LabyFabricLauncher;
import net.labymod.addons.labyfabric.loader.LabyFabricLoader;
import net.labymod.addons.labyfabric.loader.mappings.FabricIntermediaryMappingLoader;
import net.labymod.addons.labyfabric.loader.patch.FabricPatcher;
import net.labymod.addons.labyfabric.loader.transformer.FabricPatchTransformer;
import net.labymod.addons.labyfabric.loader.transformer.FabricTransformer;
import net.labymod.addons.labyfabric.remap.LabyFabricModRemapper;
import net.labymod.api.Laby;
import net.labymod.api.addon.entrypoint.Entrypoint;
import net.labymod.api.event.Event;
import net.labymod.api.event.Phase;
import net.labymod.api.event.modloader.ModLoaderInitializeEvent;
import net.labymod.api.loader.platform.PlatformClassTransformer;
import net.labymod.api.loader.platform.PlatformClassloader;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.mapping.MappingService;
import net.labymod.api.mapping.loader.MappingLoader;
import net.labymod.api.mapping.provider.MappingProvider;
import net.labymod.api.models.addon.annotation.AddonEntryPoint;
import net.labymod.api.models.version.Version;
import net.labymod.api.modloader.ModLoader;
import net.labymod.api.modloader.ModLoaderRegistry;
import net.labymod.core.addon.DefaultAddonService;
import net.minecraft.launchwrapper.Launch;

@AddonEntryPoint
public class LabyFabricEntrypoint
implements Entrypoint {
    private static ModResolutionException modResolutionException;
    private static boolean optiFineAddonPresent;

    public static ModResolutionException getModResolutionException() {
        return modResolutionException;
    }

    public static boolean isOptiFineAddonPresent() {
        return optiFineAddonPresent;
    }

    public void initialize(Version version) {
        try {
            Files.createDirectories(FabricConstants.versionedPath(FabricConstants.MODS_DIRECTORY_PATH, version.toString()), new FileAttribute[0]);
            Files.createDirectories(FabricConstants.versionedPath(FabricConstants.CONFIG_DIRECTORY_PATH, version.toString()), new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to create versioned mod directories", exception);
        }
        try {
            MappingService.instance().registerMappings((MappingLoader)new FabricIntermediaryMappingLoader());
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to register fabric intermediary mappings", exception);
        }
        PlatformClassloader classloader = PlatformEnvironment.getPlatformClassloader();
        LabyFabricLauncher launcher = new LabyFabricLauncher();
        FabricPatcher patcher = new FabricPatcher(List.of(new EntrypointPatch()));
        patcher.applyPatches(launcher);
        classloader.registerTransformer(PlatformClassloader.TransformerPhase.NORMAL, (PlatformClassTransformer)new FabricPatchTransformer(patcher));
        LabyFabricLoader loader = (LabyFabricLoader)FabricLoader.INSTANCE;
        optiFineAddonPresent = DefaultAddonService.getInstance().getAddon("optifine").isPresent();
        if (optiFineAddonPresent) {
            return;
        }
        ModLoaderRegistry.instance().register(loader.getId(), (Object)loader);
        Laby.fireEvent((Event)new ModLoaderInitializeEvent((ModLoader)loader, Phase.PRE));
        loader.init();
        MappingProvider mappings = MappingService.instance().mappings("intermediary", loader.getTargetNamespace());
        if (mappings == null) {
            throw new RuntimeException("Required mappings are not available");
        }
        try {
            loader.loadCandidates();
            try {
                new LabyFabricModRemapper(2, mappings).remap(loader.getModCandidates());
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to remap mods", exception);
            }
            loader.loadMods();
        }
        catch (ModResolutionException exception) {
            Log.error(LogCategory.RESOLUTION, "Fabric Loader failed to load mods", exception);
            modResolutionException = exception;
            return;
        }
        try {
            Class.forName("net.fabricmc.loader.impl.transformer.EnvironmentStrippingData");
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException("Failed to preload class", exception);
        }
        try {
            classloader.registerTransformer(PlatformClassloader.TransformerPhase.NORMAL, (PlatformClassTransformer)new FabricTransformer(loader, this.loadAccessWideners(loader, mappings)));
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to load access wideners", exception);
        }
        FabricMixinBootstrap.init(loader, mappings);
        Launch.classLoader.addTransformerExclusion("net.fabricmc.tinyremapper");
        try {
            loader.invokeEntrypoints("preLaunch", PreLaunchEntrypoint.class, PreLaunchEntrypoint::onPreLaunch);
        }
        catch (RuntimeException exception) {
            throw FormattedException.ofLocalized("exception.initializerFailure", exception);
        }
        Laby.fireEvent((Event)new ModLoaderInitializeEvent((ModLoader)loader, Phase.POST));
    }

    private ClassTweaker loadAccessWideners(LabyFabricLoader loader, MappingProvider mappings) throws IOException {
        ClassTweaker readAccessWidener = ClassTweaker.newInstance();
        String fromNamespace = "intermediary";
        String toNamespace = loader.getTargetNamespace();
        ClassTweakerReader reader = ClassTweakerReader.create((ClassTweakerVisitor)new ClassTweakerRemapperVisitor((ClassTweakerVisitor)readAccessWidener, MappingService.instance().asmRemapper(mappings), fromNamespace, toNamespace));
        for (ModContainer mod : loader.getAllMods()) {
            Path path;
            String accessWidener = ((LoaderModMetadata)mod.getMetadata()).getAccessWidener();
            if (accessWidener == null || (path = (Path)mod.findPath(accessWidener).orElse(null)) == null) continue;
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            try {
                reader.read(bufferedReader);
            }
            finally {
                if (bufferedReader == null) continue;
                bufferedReader.close();
            }
        }
        return readAccessWidener;
    }
}

