/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric.loader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.ObjectShare;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.impl.LazyMappingResolver;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.ObjectShareImpl;
import net.fabricmc.loader.impl.discovery.BuiltinMod;
import net.fabricmc.loader.impl.discovery.ClasspathModCandidateFinder;
import net.fabricmc.loader.impl.discovery.DirectoryModCandidateFinder;
import net.fabricmc.loader.impl.discovery.ModCandidateImpl;
import net.fabricmc.loader.impl.discovery.ModDiscoverer;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.fabricmc.loader.impl.discovery.ModResolver;
import net.fabricmc.loader.impl.entrypoint.EntrypointStorage;
import net.fabricmc.loader.impl.metadata.BuiltinModMetadata;
import net.fabricmc.loader.impl.metadata.DependencyOverrides;
import net.fabricmc.loader.impl.metadata.EntrypointMetadata;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.metadata.ModDependencyImpl;
import net.fabricmc.loader.impl.metadata.VersionOverrides;
import net.fabricmc.loader.impl.util.DefaultLanguageAdapter;
import net.fabricmc.loader.impl.util.ExceptionUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.labymod.addons.labyfabric.FabricConstants;
import net.labymod.addons.labyfabric.loader.mappings.LabyFabricMappingResolver;
import net.labymod.api.BuildData;
import net.labymod.api.Laby;
import net.labymod.api.event.Event;
import net.labymod.api.event.modloader.ModLoadEvent;
import net.labymod.api.event.modloader.ModLoaderDiscoveryEvent;
import net.labymod.api.loader.LabyModLoader;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.models.version.Version;
import net.labymod.api.modloader.ModLoader;
import net.labymod.api.modloader.mod.ModInfo;
import net.labymod.api.volt.asm.util.ASMHelper;
import net.labymod.core.loader.DefaultLabyModLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class LabyFabricLoader
extends net.fabricmc.loader.FabricLoader
implements ModLoader {
    private final LabyModLoader labyModLoader;
    private final ObjectShare objectShare;
    private final MappingResolver mappingResolver;
    private final EntrypointStorage entrypointStorage;
    private final Map<String, LanguageAdapter> adapterMap;
    private final List<ModContainer> mods;
    private final Map<String, ModContainer> modsMap;
    private List<ModCandidateImpl> modCandidates;

    public LabyFabricLoader() {
        FabricLoader.setInstance(this);
        this.labyModLoader = DefaultLabyModLoader.getInstance();
        this.objectShare = new ObjectShareImpl();
        String targetNamespace = this.getTargetNamespace();
        this.mappingResolver = new LazyMappingResolver(() -> new LabyFabricMappingResolver(targetNamespace), targetNamespace);
        this.entrypointStorage = new EntrypointStorage();
        this.adapterMap = new HashMap<String, LanguageAdapter>();
        this.mods = new ArrayList<ModContainer>();
        this.modsMap = new HashMap<String, ModContainer>();
    }

    public String getTargetNamespace() {
        return this.isDevelopmentEnvironment() ? "named" : "official";
    }

    public void init() {
        Path clientGameJarPath = PlatformEnvironment.getClientJarPath();
        this.objectShare.put("fabric-loader:inputGameJar", clientGameJarPath);
        this.objectShare.put("fabric-loader:inputGameJars", Collections.singletonList(clientGameJarPath));
    }

    public void loadCandidates() throws ModResolutionException {
        VersionOverrides versionOverrides = new VersionOverrides();
        DependencyOverrides depOverrides = new DependencyOverrides(this.getConfigDir());
        Collection additionalDiscoveries = ((ModLoaderDiscoveryEvent)Laby.fireEvent((Event)new ModLoaderDiscoveryEvent((ModLoader)this))).getAdditionalDiscoveries();
        ModDiscoverer discoverer = new ModDiscoverer(versionOverrides, depOverrides);
        discoverer.addCandidateFinder(new ClasspathModCandidateFinder());
        discoverer.addCandidateFinder(new DirectoryModCandidateFinder(this.getModsDirectory0(), true));
        discoverer.addCandidateFinder(out -> {
            for (Path additionalDiscovery : additionalDiscoveries) {
                out.accept(additionalDiscovery, true);
            }
        });
        HashMap<String, Set<ModCandidateImpl>> envDisabledMods = new HashMap<String, Set<ModCandidateImpl>>();
        this.modCandidates = discoverer.discoverMods(this, envDisabledMods);
        if (!versionOverrides.getAffectedModIds().isEmpty()) {
            Log.info(LogCategory.GENERAL, "Versions overridden for %s", String.join((CharSequence)", ", versionOverrides.getAffectedModIds()));
        }
        if (!depOverrides.getAffectedModIds().isEmpty()) {
            Log.info(LogCategory.GENERAL, "Dependencies overridden for %s", String.join((CharSequence)", ", depOverrides.getAffectedModIds()));
        }
        this.modCandidates = ModResolver.resolve(this.modCandidates, this.getEnvironmentType(), envDisabledMods);
    }

    public void loadMods() throws ModResolutionException {
        String modsToLoadLate;
        this.modCandidates.removeIf(modCandidate -> ((ModLoadEvent)Laby.fireEvent((Event)new ModLoadEvent((ModInfo)modCandidate, (ModLoader)this))).isCancelled());
        this.dumpModList(this.modCandidates);
        if (this.isDevelopmentEnvironment() && System.getProperty("fabric.debug.disableModShuffle") == null) {
            Collections.shuffle(this.modCandidates);
        }
        if ((modsToLoadLate = System.getProperty("fabric.debug.loadLate")) != null) {
            block2: for (String modId : modsToLoadLate.split(",")) {
                Iterator<ModCandidateImpl> it = this.modCandidates.iterator();
                while (it.hasNext()) {
                    ModCandidateImpl mod = it.next();
                    if (!modId.equals(mod.getId())) continue;
                    it.remove();
                    this.modCandidates.add(mod);
                    continue block2;
                }
            }
        }
        for (ModCandidateImpl mod : this.modCandidates) {
            if (!mod.hasPath() && !mod.isBuiltin()) {
                try {
                    mod.setPaths(Collections.singletonList(mod.copyToDir(FabricConstants.versionedPath(FabricConstants.MOD_REMAP_DIRECTORY_PATH), false)));
                }
                catch (IOException exception) {
                    throw new RuntimeException("Error extracting mod " + String.valueOf(mod), exception);
                }
            }
            this.addMod(mod);
        }
        this.modCandidates = null;
        this.finishModLoading();
    }

    private void dumpModList(List<ModCandidateImpl> mods) {
        StringBuilder modListText = new StringBuilder();
        boolean[] lastItemOfNestLevel = new boolean[mods.size()];
        List topLevelMods = mods.stream().filter(mod -> mod.getParentMods().isEmpty()).collect(Collectors.toList());
        int topLevelModsCount = topLevelMods.size();
        for (int i = 0; i < topLevelModsCount; ++i) {
            boolean lastItem;
            boolean bl = lastItem = i == topLevelModsCount - 1;
            if (lastItem) {
                lastItemOfNestLevel[0] = true;
            }
            this.dumpModList0((ModCandidateImpl)topLevelMods.get(i), modListText, 0, lastItemOfNestLevel);
        }
        int modsCount = mods.size();
        Log.info(LogCategory.GENERAL, "Loading %d mod%s:%n%s", modsCount, modsCount != 1 ? "s" : "", modListText);
    }

    private void dumpModList0(ModCandidateImpl mod, StringBuilder log, int nestLevel, boolean[] lastItemOfNestLevel) {
        if (log.length() > 0) {
            log.append('\n');
        }
        for (int depth = 0; depth < nestLevel; ++depth) {
            log.append(depth == 0 ? "\t" : (lastItemOfNestLevel[depth] ? "     " : "   | "));
        }
        log.append(nestLevel == 0 ? "\t" : "  ");
        log.append(nestLevel == 0 ? "-" : (lastItemOfNestLevel[nestLevel] ? " \\--" : " |--"));
        log.append(' ');
        log.append(mod.getId());
        log.append(' ');
        log.append(mod.getVersion().getFriendlyString());
        ArrayList<ModCandidateImpl> nestedMods = new ArrayList<ModCandidateImpl>(mod.getNestedMods());
        nestedMods.sort(Comparator.comparing(nestedMod -> nestedMod.getMetadata().getId()));
        if (!nestedMods.isEmpty()) {
            Iterator iterator = nestedMods.iterator();
            while (iterator.hasNext()) {
                boolean lastItem;
                ModCandidateImpl nestedMod2 = (ModCandidateImpl)iterator.next();
                boolean bl = lastItem = !iterator.hasNext();
                if (lastItem) {
                    lastItemOfNestLevel[nestLevel + 1] = true;
                }
                this.dumpModList0(nestedMod2, log, nestLevel + 1, lastItemOfNestLevel);
                if (!lastItem) continue;
                lastItemOfNestLevel[nestLevel + 1] = false;
            }
        }
    }

    private void finishModLoading() {
        for (ModContainer mod : this.mods) {
            if (mod.getMetadata().getId().equals("fabricloader") || mod.getMetadata().getType().equals("builtin")) continue;
            for (Path path : ((ModContainerImpl)mod).getCodeSourcePaths()) {
                PlatformEnvironment.getPlatformClassloader().addPath(path);
            }
        }
        this.setupLanguageAdapters();
        this.setupEntrypoints();
    }

    private void addMod(ModCandidateImpl candidate) {
        ModContainerImpl container = new ModContainerImpl(candidate);
        this.mods.add(container);
        this.modsMap.put(candidate.getId(), container);
        for (String provides : candidate.getProvides()) {
            this.modsMap.put(provides, container);
        }
    }

    private void setupEntrypoints() {
        for (ModContainer mod : this.mods) {
            try {
                LoaderModMetadata info = ((ModContainerImpl)mod).getInfo();
                for (String key : info.getEntrypointKeys()) {
                    for (EntrypointMetadata in : info.getEntrypoints(key)) {
                        this.entrypointStorage.add((ModContainerImpl)mod, key, in, this.adapterMap);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to setup mod %s (%s)", ((ModContainerImpl)mod).getInfo().getName(), mod.getOrigin()), e);
            }
        }
    }

    private void setupLanguageAdapters() {
        this.adapterMap.put("default", DefaultLanguageAdapter.INSTANCE);
        for (ModContainer mod : this.mods) {
            for (Map.Entry<String, String> laEntry : ((ModContainerImpl)mod).getInfo().getLanguageAdapterDefinitions().entrySet()) {
                if (this.adapterMap.containsKey(laEntry.getKey())) {
                    throw new RuntimeException("Duplicate language adapter key: " + laEntry.getKey() + "! (" + laEntry.getValue() + ", " + this.adapterMap.get(laEntry.getKey()).getClass().getName() + ")");
                }
                try {
                    this.adapterMap.put(laEntry.getKey(), (LanguageAdapter)Class.forName(laEntry.getValue()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to instantiate language adapter: " + laEntry.getKey(), exception);
                }
            }
        }
    }

    public List<ModCandidateImpl> getModCandidates() {
        return this.modCandidates;
    }

    public Collection<BuiltinMod> getBuiltinMods() {
        HashSet<BuiltinMod> builtinMods = new HashSet<BuiltinMod>();
        BuiltinModMetadata.Builder metadata = new BuiltinModMetadata.Builder("minecraft", PlatformEnvironment.getRunningVersion()).setName("Minecraft");
        int version = ASMHelper.getCurrentJavaClassVersion() - 44;
        try {
            metadata.addDependency(new ModDependencyImpl(ModDependency.Kind.DEPENDS, "java", Collections.singletonList(String.format(">=%d", version))));
        }
        catch (VersionParsingException exception) {
            throw new RuntimeException(exception);
        }
        builtinMods.add(new BuiltinMod(Collections.singletonList(PlatformEnvironment.getClientJarPath()), metadata.build()));
        metadata = new BuiltinModMetadata.Builder("labymod", BuildData.getVersion().replace(' ', '-')).setName("LabyMod").setEnvironment(ModEnvironment.CLIENT);
        builtinMods.add(new BuiltinMod(Collections.singletonList(PlatformEnvironment.getClientJarPath()), metadata.build()));
        return builtinMods;
    }

    @Override
    public <T> List<T> getEntrypoints(String key, Class<T> type) {
        return this.entrypointStorage.getEntrypoints(key, type);
    }

    @Override
    protected Path getModsDirectory0() {
        return FabricConstants.versionedPath(FabricConstants.MODS_DIRECTORY_PATH);
    }

    @Override
    public boolean hasEntrypoints(String key) {
        return this.entrypointStorage.hasEntrypoints(key);
    }

    @Override
    public <T> List<EntrypointContainer<T>> getEntrypointContainers(String key, Class<T> type) {
        return this.entrypointStorage.getEntrypointContainers(key, type);
    }

    @Override
    public <T> void invokeEntrypoints(String key, Class<T> type, Consumer<? super T> invoker) {
        if (!this.hasEntrypoints(key)) {
            Log.debug(LogCategory.ENTRYPOINT, "No subscribers for entrypoint '%s'", key);
            return;
        }
        RuntimeException exception = null;
        List<EntrypointContainer<T>> entrypoints = this.getEntrypointContainers(key, type);
        Log.debug(LogCategory.ENTRYPOINT, "Iterating over entrypoint '%s'", key);
        for (EntrypointContainer entrypointContainer : entrypoints) {
            try {
                invoker.accept(entrypointContainer.getEntrypoint());
            }
            catch (Throwable t) {
                exception = ExceptionUtil.gatherExceptions(t, exception, exc -> new RuntimeException(String.format("Could not execute entrypoint stage '%s' due to errors, provided by '%s' at '%s'!", key, container.getProvider().getMetadata().getId(), container.getDefinition()), (Throwable)exc));
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public ObjectShare getObjectShare() {
        return this.objectShare;
    }

    @Override
    public MappingResolver getMappingResolver() {
        return this.mappingResolver;
    }

    @Override
    public Optional<ModContainer> getModContainer(String id) {
        return Optional.ofNullable(this.modsMap.get(id));
    }

    @Override
    public Collection<ModContainer> getAllMods() {
        return Collections.unmodifiableCollection(this.mods);
    }

    @NotNull
    public String getId() {
        return "fabricloader";
    }

    @NotNull
    public Version version() {
        return FabricConstants.LOADER_VERSION;
    }

    @NotNull
    public String getExpectedMappingNamespace() {
        return "intermediary";
    }

    @NotNull
    public @Unmodifiable Collection<Path> getModDirectoryPaths() {
        return Collections.singletonList(FabricConstants.versionedPath(FabricConstants.MODS_DIRECTORY_PATH));
    }

    @NotNull
    public @Unmodifiable Collection<Path> getConfigDirectoryPaths() {
        return Collections.singletonList(this.getConfigDir());
    }

    @NotNull
    public @Unmodifiable Collection<ModInfo> getModInfos() {
        return Collections.unmodifiableCollection(this.mods);
    }

    @Nullable
    public ModInfo getModInfo(@NotNull String id) {
        return this.getModContainer(id).orElse(null);
    }

    @Override
    public boolean isModLoaded(@NotNull String id) {
        return this.modsMap.containsKey(id);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return this.labyModLoader.isLabyModDevelopmentEnvironment();
    }

    @Override
    public EnvType getEnvironmentType() {
        return EnvType.CLIENT;
    }

    @Override
    public Object getGameInstance() {
        return Laby.labyAPI().minecraft();
    }

    @Override
    public Path getGameDir() {
        return this.labyModLoader.getGameDirectory();
    }

    @Override
    public File getGameDirectory() {
        return this.getGameDir().toFile();
    }

    @Override
    public Path getConfigDir() {
        return FabricConstants.versionedPath(FabricConstants.CONFIG_DIRECTORY_PATH);
    }

    @Override
    public File getConfigDirectory() {
        return this.getConfigDir().toFile();
    }

    @Override
    public String[] getLaunchArguments(boolean sanitize) {
        return this.labyModLoader.getArguments().toArray(new String[0]);
    }

    public static class InitHelper {
        private static LabyFabricLoader instance;

        public static LabyFabricLoader get() {
            if (instance == null) {
                instance = new LabyFabricLoader();
            }
            return instance;
        }
    }
}

