/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric.loader.mappings;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.labymod.addons.labyfabric.FabricConstants;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.mapping.MappingType;
import net.labymod.api.mapping.loader.MappingLoader;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.FileRequest;
import org.jetbrains.annotations.NotNull;

public class FabricIntermediaryMappingLoader
implements MappingLoader {
    private static final String INTERMEDIARY_URL = "https://raw.githubusercontent.com/FabricMC/intermediary/master/mappings/%s.tiny";
    private static final String LEGACY_INTERMEDIARY_URL = "https://raw.githubusercontent.com/Legacy-Fabric/Legacy-Intermediaries/v2/legacy/mappings/%s.tiny";
    private final Path mappingsPath = Paths.get(String.format(FabricConstants.INTERMEDIARY_MAPPINGS_PATH, PlatformEnvironment.getRunningVersion()), new String[0]);

    @NotNull
    public String getSourceNamespace() {
        return "official";
    }

    @NotNull
    public String getTargetNamespace() {
        return "intermediary";
    }

    @NotNull
    public MappingType type() {
        return MappingType.TINY_V1;
    }

    @NotNull
    public InputStream load() throws IOException {
        Response response;
        if (!Files.exists(this.mappingsPath, new LinkOption[0]) && (response = ((FileRequest)Request.ofFile((Path)this.mappingsPath).url(PlatformEnvironment.isNoMojangMappings() ? LEGACY_INTERMEDIARY_URL : INTERMEDIARY_URL, new Object[]{PlatformEnvironment.getRunningVersion()})).executeSync()).hasException()) {
            throw response.exception();
        }
        return Files.newInputStream(this.mappingsPath, new OpenOption[0]);
    }
}

