/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.util.log;

import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.log.LogHandler;
import net.fabricmc.loader.impl.util.log.LogLevel;
import net.labymod.api.util.logging.Logging;
import net.labymod.core.util.logging.DefaultLoggingFactory;

public class ConsoleLogHandler
implements LogHandler {
    private static final LogLevel MIN_STDOUT_LEVEL = LogLevel.getDefault();
    private final Logging logging = DefaultLoggingFactory.createLogger((String)"LabyFabric");

    @Override
    public void log(long time, LogLevel level, LogCategory category, String msg, Throwable exc, boolean fromReplay, boolean wasSuppressed) {
        String formatted = String.format("[%s/%s]: %s", category.context, category.name, msg);
        switch (level) {
            case ERROR: 
            case TRACE: {
                this.logging.error((CharSequence)formatted, exc);
                break;
            }
            case INFO: {
                this.logging.info((CharSequence)formatted, exc);
                break;
            }
            case WARN: {
                this.logging.warn((CharSequence)formatted, exc);
                break;
            }
            case DEBUG: {
                this.logging.debug((CharSequence)formatted, exc);
            }
        }
    }

    @Override
    public boolean shouldLog(LogLevel level, LogCategory category) {
        return !level.isLessThan(MIN_STDOUT_LEVEL);
    }

    @Override
    public void close() {
    }
}

