/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric;

import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import net.labymod.addons.labyfabric.configuration.LabyFabricConfiguration;
import net.labymod.addons.labyfabric.launch.LabyFabricEntrypoint;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.configuration.settings.Setting;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.notification.Notification;
import net.labymod.api.util.KeyValue;

@AddonMain
@Singleton
public class LabyFabric
extends LabyAddon<LabyFabricConfiguration> {
    private static final String NAMESPACE = Laby.labyAPI().getNamespace(LabyFabric.class);
    private static final Icon FABRIC_ICON = Icon.texture((ResourceLocation)ResourceLocation.create((String)NAMESPACE, (String)"textures/icon.png"));

    protected void enable() {
        super.registerSettingCategory();
        Component errorPrefixComponent = Component.translatable((String)"labyfabric.notification.errorPrefix", (Component[])new Component[0]).append((Component)Component.space());
        if (LabyFabricEntrypoint.getModResolutionException() != null) {
            this.showNotification(((TextComponent)Component.empty().append(errorPrefixComponent)).append((Component)Component.translatable((String)"labyfabric.notification.modResolutionError", (Component[])new Component[0])));
        }
        if (LabyFabricEntrypoint.isOptiFineAddonPresent()) {
            this.showNotification(((TextComponent)Component.empty().append(errorPrefixComponent)).append((Component)Component.translatable((String)"labyfabric.notification.optiFineError", (Component[])new Component[0])));
        }
    }

    protected Class<LabyFabricConfiguration> configurationClass() {
        return LabyFabricConfiguration.class;
    }

    private void showNotification(Component text) {
        Notification.Builder notificationBuilder = Notification.builder().title((Component)Component.translatable((String)"labyfabric.settings.name", (Component[])new Component[0])).text(text).icon(FABRIC_ICON).duration(TimeUnit.SECONDS.toMillis(20L)).type(Notification.Type.SYSTEM);
        KeyValue addonSettingsEntry = this.labyAPI().coreSettingRegistry().getElementById(NAMESPACE);
        if (addonSettingsEntry != null) {
            notificationBuilder.onClick(notification -> this.labyAPI().showSetting((Setting)addonSettingsEntry.getValue()));
        }
        Laby.references().notificationController().push(notificationBuilder.build());
    }
}

