/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric.loader.patch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.impl.game.patch.GamePatch;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class FabricPatcher {
    private final List<GamePatch> patches;
    private final Map<String, byte[]> patchedClassData;

    public FabricPatcher(List<GamePatch> patches) {
        this.patches = patches;
        this.patchedClassData = new HashMap<String, byte[]>();
    }

    private static ClassNode readClass(byte[] classData) {
        ClassReader reader = new ClassReader(classData);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        return node;
    }

    public void applyPatches(FabricLauncher fabricLauncher) {
        HashMap patchedClassNodes = new HashMap();
        for (GamePatch patch : this.patches) {
            patch.process(fabricLauncher, className -> patchedClassNodes.computeIfAbsent(className, name -> FabricPatcher.readClass(this.patchedClassData.containsKey(name) ? this.patchedClassData.get(name) : Launch.classLoader.getClassBytes(name))), classNode -> patchedClassNodes.put(classNode.name, classNode));
        }
        for (ClassNode node : patchedClassNodes.values()) {
            String name = node.name.replace('/', '.');
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            this.patchedClassData.put(name, writer.toByteArray());
        }
    }

    public byte[] transform(String className, byte[] classData) {
        return this.patchedClassData.getOrDefault(className, classData);
    }
}

