/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric.remap;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.classtweaker.api.ClassTweaker;
import net.fabricmc.classtweaker.api.ClassTweakerReader;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.loader.impl.discovery.ModCandidateImpl;
import net.fabricmc.loader.impl.util.FileSystemUtil;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.extension.mixin.MixinExtension;
import net.labymod.addons.labyfabric.FabricConstants;
import net.labymod.addons.labyfabric.remap.LabyFabricMappingProvider;
import net.labymod.addons.labyfabric.remap.RemapUtil;
import net.labymod.api.Constants;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.mapping.MappingService;
import net.labymod.api.mapping.provider.MappingProvider;
import org.spongepowered.asm.util.asm.ASM;

public class LabyFabricModRemapper {
    private final int remapVersion;
    private final MappingProvider mappings;

    public LabyFabricModRemapper(int remapVersion, MappingProvider mappings) {
        this.remapVersion = remapVersion;
        this.mappings = mappings;
    }

    private void checkVersion(Path remapPath) throws IOException {
        Path remapVersionPath = FabricConstants.versionedPath(FabricConstants.MAP_REMAP_VERSION_PATH);
        if (Files.exists(remapVersionPath, new LinkOption[0])) {
            String fileContent = Files.readString(remapVersionPath);
            try {
                if (Integer.parseInt(fileContent) == this.remapVersion) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Files.exists(remapPath, new LinkOption[0])) {
            try (Stream<Path> walker = Files.walk(remapPath, new FileVisitOption[0]);){
                for (Path path : walker.sorted(Comparator.reverseOrder()).toList()) {
                    Files.deleteIfExists(path);
                }
            }
        }
        Files.createDirectories(remapVersionPath.getParent(), new FileAttribute[0]);
        Files.writeString(remapVersionPath, (CharSequence)String.valueOf(this.remapVersion), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private byte[] readModCandidateFile(ModCandidateImpl candidate, Path inputPath, String filePath) {
        byte[] byArray;
        block8: {
            FileSystemUtil.FileSystemDelegate jarFileSystem = FileSystemUtil.getJarFileSystem(inputPath, false);
            try {
                FileSystem fileSystem = jarFileSystem.get();
                byArray = Files.readAllBytes(fileSystem.getPath(filePath, new String[0]));
                if (jarFileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFileSystem != null) {
                        try {
                            jarFileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new RuntimeException("Error reading file '" + filePath + "' for mod '" + candidate.getId() + "'", exception);
                }
            }
            jarFileSystem.close();
        }
        return byArray;
    }

    private Path getSourceMinecraftJar() throws IOException {
        Path sourceMinecraftJar = Paths.get(String.format(Locale.ROOT, Constants.Files.REMAP_JAR_PATH, PlatformEnvironment.getRunningVersion(), this.mappings.getSourceNamespace() + "-fabric"), new String[0]);
        if (!Files.exists(sourceMinecraftJar, new LinkOption[0])) {
            TinyRemapper sourceRemapper = TinyRemapper.newRemapper().withMappings((IMappingProvider)new LabyFabricMappingProvider(MappingService.instance().mappings("official", this.mappings.getSourceNamespace()))).build();
            InputTag tag = sourceRemapper.createInputTag();
            sourceRemapper.readInputsAsync(tag, new Path[]{PlatformEnvironment.getObfuscatedJarPath()});
            OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(sourceMinecraftJar).build();
            sourceRemapper.apply((BiConsumer)outputConsumer, new InputTag[]{tag});
            sourceRemapper.finish();
            outputConsumer.close();
        }
        return sourceMinecraftJar;
    }

    public void remap(Collection<ModCandidateImpl> modCandidates) throws IOException {
        Path remappedModsDirectoryPath = FabricConstants.versionedPath(FabricConstants.MOD_REMAP_DIRECTORY_PATH, PlatformEnvironment.getRunningVersion());
        Path inputDir = FabricConstants.versionedPath(FabricConstants.MOD_REMAP_INPUT_DIRECTORY_PATH, PlatformEnvironment.getRunningVersion());
        this.checkVersion(remappedModsDirectoryPath);
        HashMap<ModCandidateImpl, Path> inputPaths = new HashMap<ModCandidateImpl, Path>();
        ClassTweaker classTweaker = ClassTweaker.newInstance();
        for (ModCandidateImpl modCandidate : modCandidates) {
            if (!modCandidate.getRequiresRemap()) continue;
            Path inputPath = modCandidate.hasPath() ? modCandidate.getPaths().getFirst() : modCandidate.copyToDir(inputDir, false);
            inputPaths.put(modCandidate, inputPath);
            String accessWidenerPath = modCandidate.getMetadata().getAccessWidener();
            if (accessWidenerPath == null) continue;
            ClassTweakerReader reader = ClassTweakerReader.create((ClassTweakerVisitor)classTweaker);
            reader.read(this.readModCandidateFile(modCandidate, inputPath, accessWidenerPath));
        }
        HashSet<InputTag> mixinTags = new HashSet<InputTag>();
        TinyRemapper tinyRemapper = TinyRemapper.newRemapper().withMappings((IMappingProvider)new LabyFabricMappingProvider(this.mappings)).renameInvalidLocals(false).extension((TinyRemapper.Extension)new MixinExtension(mixinTags::contains)).extraAnalyzeVisitor((mrjVersion, className, next) -> classTweaker.createClassVisitor(ASM.API_VERSION, next, null)).build();
        tinyRemapper.readClassPathAsync(new Path[]{this.getSourceMinecraftJar(), PlatformEnvironment.getClientJarPath()});
        HashMap<ModCandidateImpl, InputTag> inputTags = new HashMap<ModCandidateImpl, InputTag>();
        HashSet<OutputConsumerPath> outputConsumers = new HashSet<OutputConsumerPath>();
        for (ModCandidateImpl modCandidate : modCandidates) {
            if (!modCandidate.getRequiresRemap()) continue;
            Path inputPath = (Path)inputPaths.get(modCandidate);
            InputTag tag = tinyRemapper.createInputTag();
            inputTags.put(modCandidate, tag);
            if (RemapUtil.requiresMixinRemap(inputPath)) {
                mixinTags.add(tag);
            }
            tinyRemapper.readInputsAsync(tag, new Path[]{inputPath});
        }
        for (ModCandidateImpl modCandidate : modCandidates) {
            if (!modCandidate.getRequiresRemap()) continue;
            Path outputPath = remappedModsDirectoryPath.resolve(modCandidate.getDefaultFileName());
            modCandidate.setPaths(Collections.singletonList(outputPath));
            if (Files.exists(outputPath, new LinkOption[0])) continue;
            OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(outputPath).assumeArchive(true).build();
            outputConsumer.addNonClassFiles((Path)inputPaths.get(modCandidate), NonClassCopyMode.FIX_META_INF, tinyRemapper);
            outputConsumers.add(outputConsumer);
            tinyRemapper.apply((BiConsumer)outputConsumer, new InputTag[]{(InputTag)inputTags.get(modCandidate)});
        }
        tinyRemapper.finish();
        for (OutputConsumerPath outputConsumer : outputConsumers) {
            outputConsumer.close();
        }
    }
}

