/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.api;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.ObjectShare;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;

public interface FabricLoader {
    public static final AtomicReference<FabricLoader> instanceRef = new AtomicReference<Object>(null);

    public static FabricLoader getInstance() {
        if (instanceRef.get() == null) {
            throw new RuntimeException("Accessed FabricLoader too early!");
        }
        return instanceRef.get();
    }

    public static void setInstance(FabricLoader instance) {
        if (instanceRef.get() != null) {
            throw new RuntimeException("Instance already set!");
        }
        instanceRef.set(instance);
    }

    public <T> List<T> getEntrypoints(String var1, Class<T> var2);

    public boolean hasEntrypoints(String var1);

    public <T> List<EntrypointContainer<T>> getEntrypointContainers(String var1, Class<T> var2);

    public <T> void invokeEntrypoints(String var1, Class<T> var2, Consumer<? super T> var3);

    public ObjectShare getObjectShare();

    public MappingResolver getMappingResolver();

    public Optional<ModContainer> getModContainer(String var1);

    public Collection<ModContainer> getAllMods();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public EnvType getEnvironmentType();

    @Deprecated
    public Object getGameInstance();

    public Path getGameDir();

    @Deprecated
    public File getGameDirectory();

    public Path getConfigDir();

    @Deprecated
    public File getConfigDirectory();

    public String[] getLaunchArguments(boolean var1);
}

