/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.tiny.Tiny1FileReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.labymod.addons.labyfabric.FabricConstants;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.mapping.MappingService;
import net.labymod.api.mapping.provider.MappingProvider;
import net.labymod.api.mapping.provider.child.ClassMapping;
import net.labymod.api.mapping.provider.child.FieldMapping;
import net.labymod.api.mapping.provider.child.MethodMapping;
import net.labymod.api.util.io.IOUtil;
import net.minecraftforge.srgutils.IMappingBuilder;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.INamedMappingFile;
import org.jetbrains.annotations.Nullable;

public final class MappingConfiguration {
    private static final boolean FIX_PACKAGE_ACCESS = System.getProperty("fabric.fixPackageAccess") != null;
    private boolean initializedMappings = false;
    @Nullable
    private String gameId;
    @Nullable
    private String gameVersion;
    @Nullable
    private List<String> namespaces;
    @Nullable
    private MemoryMappingTree mappings;

    public String getGameId() {
        this.initialize();
        return this.gameId;
    }

    public String getGameVersion() {
        this.initialize();
        return this.gameVersion;
    }

    @Nullable
    public List<String> getNamespaces() {
        this.initialize();
        return this.namespaces;
    }

    public boolean matches(String gameId, String gameVersion) {
        this.initialize();
        return !(this.gameId != null && gameId != null && !gameId.equals(this.gameId) || this.gameVersion != null && gameVersion != null && !gameVersion.equals(this.gameVersion));
    }

    public MappingTree getMappings() {
        this.initialize();
        return this.mappings;
    }

    public String getTargetNamespace() {
        return FabricLauncherBase.getLauncher().getTargetNamespace();
    }

    public boolean requiresPackageAccessHack() {
        return FIX_PACKAGE_ACCESS || this.getTargetNamespace().equals("named");
    }

    private void initialize() {
        if (this.initializedMappings) {
            return;
        }
        this.gameId = "minecraft";
        this.gameVersion = PlatformEnvironment.getRunningVersion();
        this.mappings = new MemoryMappingTree();
        this.namespaces = new ArrayList<String>();
        String currentNamespace = this.getTargetNamespace();
        MappingProvider intermediaryToOfficial = MappingService.instance().mappings("intermediary", "official");
        MappingProvider officialToCurrent = MappingService.instance().mappings("official", currentNamespace);
        if (intermediaryToOfficial == null || officialToCurrent == null) {
            this.initializedMappings = true;
            return;
        }
        if ("official".equals(currentNamespace)) {
            currentNamespace = "unused";
        }
        IMappingBuilder mappingBuilder = IMappingBuilder.create((String[])new String[]{"intermediary", "official", currentNamespace});
        for (ClassMapping classMapping : intermediaryToOfficial.getClassMappings()) {
            IMappingBuilder.IClass iClass = mappingBuilder.addClass(new String[]{classMapping.getName(), classMapping.getMappedName(), officialToCurrent.mapClass(classMapping.getMappedName())});
            ClassMapping secondClassMapping = officialToCurrent.getClassMapping(classMapping.getMappedName());
            for (FieldMapping fieldMapping : classMapping.getFieldMappings()) {
                iClass.field(new String[]{fieldMapping.getName(), fieldMapping.getMappedName(), secondClassMapping == null ? fieldMapping.getMappedName() : secondClassMapping.mapField(fieldMapping.getMappedName())}).descriptor(fieldMapping.getDescriptor());
            }
            for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
                iClass.method(methodMapping.getDescriptor(), new String[]{methodMapping.getName(), methodMapping.getMappedName(), secondClassMapping == null ? methodMapping.getMappedName() : secondClassMapping.mapMethod(methodMapping.getMappedName(), methodMapping.getMappedDescriptor())});
            }
            if (!FabricLauncherBase.getLauncher().isDevelopment()) continue;
            this.addOptiFineDevMappings(classMapping, iClass);
        }
        try {
            Path tempMappingsPath = FabricConstants.versionedPath(FabricConstants.TEMP_MAPPINGS_PATH);
            INamedMappingFile namedMappingFile = mappingBuilder.build();
            namedMappingFile.write(tempMappingsPath, IMappingFile.Format.TINY1);
            try (BufferedReader bufferedReader = Files.newBufferedReader(tempMappingsPath);){
                Tiny1FileReader.read((Reader)bufferedReader, (MappingVisitor)this.mappings);
            }
            bufferedReader = Files.newBufferedReader(tempMappingsPath);
            try {
                this.namespaces.addAll(Tiny1FileReader.getNamespaces((Reader)bufferedReader));
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            IOUtil.deleteIfExits((Path)tempMappingsPath);
            this.initializedMappings = true;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void addOptiFineDevMappings(ClassMapping classMapping, IMappingBuilder.IClass iClass) {
        if (classMapping.getName().equals("net/minecraft/class_638")) {
            iClass.method("(Lnet/minecraft/class_1297;)V", new String[]{"onEntityRemoved", "onEntityRemoved", "onEntityRemovedOptiFine"});
        }
        if (classMapping.getName().equals("net/minecraft/class_777")) {
            iClass.method("()Lnet/minecraft/class_1058;", new String[]{"getSprite", "getSprite", "getSpriteOptiFine"});
        }
        if (classMapping.getName().equals("net/minecraft/class_457")) {
            iClass.method("(Ljava/lang/String;)Lnet/minecraft/class_457;", new String[]{"getChild", "getChild", "getChildOptiFine"});
        }
        if (classMapping.getName().equals("net/minecraft/class_7172$class_7173")) {
            iClass.method("()Lcom/mojang/serialization/Codec;", new String[]{"codec", "codec", "codecOptiFine"});
        }
        if (classMapping.getName().equals("net/minecraft/class_7172$class_7273")) {
            iClass.method("()Lnet/minecraft/class_7172$class_7305$class_7274;", new String[]{"valueSplitter", "valueSplitter", "valueSplitterOptiFine"});
            iClass.method("()Lnet/minecraft/class_7172$class_7305$class_7274;", new String[]{"valueSetter", "valueSetter", "valueSetterOptiFine"});
            iClass.method("()Lcom/mojang/serialization/Codec;", new String[]{"codec", "codec", "codecOptiFine"});
        }
        if (classMapping.getName().equals("net/minecraft/class_7172$class_7276")) {
            iClass.method("()Lcom/mojang/serialization/Codec;", new String[]{"codec", "codec", "codecOptiFine"});
        }
        if (classMapping.getName().equals("net/minecraft/class_1088")) {
            iClass.method("(Lnet/minecraft/class_2960;)Lnet/minecraft/class_793;", new String[]{"loadBlockModel", "loadBlockModel", "loadBlockModelOptiFine"});
        }
    }
}

