/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.version.VersionInterval;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.labymod.api.models.version.Version;
import net.labymod.api.models.version.VersionComparison;
import net.labymod.api.modloader.mod.ModDependency;
import net.labymod.api.util.version.comparison.VersionMultiRangeComparison;
import org.jetbrains.annotations.NotNull;

public final class ModDependencyImpl
implements ModDependency {
    private final String modId;
    private final List<String> matcherStringList;
    private final Collection<VersionPredicate> ranges;
    private ModDependency.Kind kind;

    public ModDependencyImpl(ModDependency.Kind kind, String modId, List<String> matcherStringList) throws VersionParsingException {
        this.kind = kind;
        this.modId = modId;
        this.matcherStringList = matcherStringList;
        this.ranges = VersionPredicate.parse(this.matcherStringList);
    }

    @Override
    public ModDependency.Kind getKind() {
        return this.kind;
    }

    public void setKind(ModDependency.Kind kind) {
        this.kind = kind;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @NotNull
    public VersionComparison<Version> versionCompatibility() {
        String multiRange = this.ranges.stream().map(range -> {
            VersionInterval interval = range.getInterval();
            String min = interval.getMin() == null ? "*" : interval.getMin().toString();
            String max = interval.getMax() == null ? "*" : interval.getMax().toString();
            return String.format("%s<%s", min, max);
        }).collect(Collectors.joining(","));
        return VersionMultiRangeComparison.parse((String)multiRange, net.fabricmc.loader.api.Version::parse);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModDependency.Kind kind() {
        return switch (this.kind) {
            default -> throw new MatchException(null, null);
            case ModDependency.Kind.DEPENDS -> ModDependency.Kind.DEPENDS;
            case ModDependency.Kind.RECOMMENDS -> ModDependency.Kind.RECOMMENDS;
            case ModDependency.Kind.SUGGESTS -> ModDependency.Kind.SUGGESTS;
            case ModDependency.Kind.CONFLICTS -> ModDependency.Kind.CONFLICTS;
            case ModDependency.Kind.BREAKS -> ModDependency.Kind.BREAKS;
        };
    }

    @Override
    public boolean matches(net.fabricmc.loader.api.Version version) {
        for (VersionPredicate predicate : this.ranges) {
            if (!predicate.test(version)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModDependency)) {
            return false;
        }
        ModDependency o = (ModDependency)obj;
        return this.kind == o.getKind() && this.modId.equals(o.getModId()) && this.ranges.equals(o.getVersionRequirements());
    }

    public int hashCode() {
        return (this.kind.ordinal() * 31 + this.modId.hashCode()) * 257 + this.ranges.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append(this.kind.getKey());
        builder.append(' ');
        builder.append(this.modId);
        builder.append(" @ [");
        for (int i = 0; i < this.matcherStringList.size(); ++i) {
            if (i > 0) {
                builder.append(" || ");
            }
            builder.append(this.matcherStringList.get(i));
        }
        builder.append("]}");
        return builder.toString();
    }

    @Override
    public Collection<VersionPredicate> getVersionRequirements() {
        return this.ranges;
    }

    @Override
    public List<VersionInterval> getVersionIntervals() {
        List<VersionInterval> ret = Collections.emptyList();
        for (VersionPredicate predicate : this.ranges) {
            ret = VersionInterval.or(ret, predicate.getInterval());
        }
        return ret;
    }
}

