/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.labyfabric.loader.mappings;

import java.util.Collection;
import net.fabricmc.loader.api.MappingResolver;
import net.labymod.api.mapping.MappingService;
import net.labymod.api.mapping.provider.MappingProvider;
import net.labymod.api.mapping.provider.child.ClassMapping;
import net.labymod.api.mapping.provider.child.MethodMapping;

public class LabyFabricMappingResolver
implements MappingResolver {
    private final String targetNamespace;

    public LabyFabricMappingResolver(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    public Collection<String> getNamespaces() {
        return MappingService.instance().getNamespaces();
    }

    @Override
    public String getCurrentRuntimeNamespace() {
        return this.targetNamespace;
    }

    @Override
    public String mapClassName(String namespace, String className) {
        className = this.reflectToPath(className);
        MappingProvider provider = MappingService.instance().mappings(namespace, this.targetNamespace);
        return this.pathToReflect(provider == null ? className : provider.mapClass(className));
    }

    @Override
    public String unmapClassName(String targetNamespace, String className) {
        className = this.reflectToPath(className);
        MappingProvider provider = MappingService.instance().mappings(this.targetNamespace, targetNamespace);
        return this.pathToReflect(provider == null ? className : provider.mapClass(className));
    }

    @Override
    public String mapFieldName(String namespace, String owner, String name, String descriptor) {
        MappingProvider provider = MappingService.instance().mappings(namespace, this.targetNamespace);
        if (provider == null) {
            return name;
        }
        ClassMapping classMapping = provider.getClassMapping(this.reflectToPath(owner));
        return classMapping == null ? name : classMapping.mapField(name);
    }

    @Override
    public String mapMethodName(String namespace, String owner, String name, String descriptor) {
        MappingProvider provider = MappingService.instance().mappings(namespace, this.targetNamespace);
        if (provider == null) {
            return name;
        }
        ClassMapping classMapping = provider.getClassMapping(this.reflectToPath(owner));
        if (classMapping == null) {
            return name;
        }
        String mappedName = classMapping.mapMethod(name, provider.reverse().mapDescriptor(descriptor));
        if (name.equals(mappedName)) {
            for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
                if (!name.equals(methodMapping.getName())) continue;
                return methodMapping.getMappedName();
            }
        }
        return mappedName;
    }

    private String reflectToPath(String className) {
        return className.replace(".", "/");
    }

    private String pathToReflect(String className) {
        return className.replace("/", ".");
    }
}

