/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class LoaderUtil {
    private static final ConcurrentMap<Path, Path> pathNormalizationCache = new ConcurrentHashMap<Path, Path>();

    public static String getClassFileName(String className) {
        return className.replace('.', '/').concat(".class");
    }

    public static Path normalizePath(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return LoaderUtil.normalizeExistingPath(path);
        }
        return path.toAbsolutePath().normalize();
    }

    public static Path normalizeExistingPath(Path path) {
        return pathNormalizationCache.computeIfAbsent(path, LoaderUtil::normalizeExistingPath0);
    }

    private static Path normalizeExistingPath0(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void verifyNotInTargetCl(Class<?> cls) {
        if (cls.getClassLoader().getClass().getName().equals("net.fabricmc.loader.impl.launch.knot.KnotClassLoader")) {
            throw new IllegalStateException("trying to load " + cls.getName() + " from target class loader");
        }
    }

    public static boolean hasMacOs() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    }

    public static boolean hasAwtSupport() {
        if (LoaderUtil.hasMacOs()) {
            for (String key : System.getenv().keySet()) {
                if (!key.startsWith("JAVA_STARTED_ON_FIRST_THREAD_")) continue;
                return false;
            }
        }
        return true;
    }
}

