/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labygpt.api;

import com.google.gson.Gson;
import com.rappytv.labygpt.api.GPTMessage;
import com.rappytv.labygpt.api.ResponseBody;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.labymod.api.util.I18n;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.types.GsonRequest;

public class GPTRequest {
    private static final Gson gson = new Gson();
    public static final ArrayList<GPTMessage> queryHistory = new ArrayList();

    public static void sendRequestAsync(String query, String key, String username, String model, String behavior, Consumer<ApiResponse> responseConsumer) {
        if (queryHistory.isEmpty()) {
            queryHistory.add(new GPTMessage(behavior, GPTMessage.GPTRole.System, "System"));
        }
        queryHistory.add(new GPTMessage(query, GPTMessage.GPTRole.User, username));
        Map<String, String> body = Map.of("model", model, "messages", gson.toJson(queryHistory), "user", username);
        ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(ResponseBody.class).url("https://api.openai.com/v1/chat/completions", new Object[0])).method(Request.Method.POST)).addHeader("Content-Type", (Object)"application/json")).addHeader("Authorization", (Object)("Bearer " + key))).json(body)).handleErrorStream()).async()).execute(response -> {
            boolean successful;
            String output = null;
            String error = null;
            ResponseBody responseBody = (ResponseBody)response.get();
            if (response.hasException()) {
                successful = false;
                error = response.exception().getLocalizedMessage();
            } else if (responseBody.error != null) {
                error = responseBody.error.message;
                if (error.isEmpty() && responseBody.error.code.equals("invalid_api_key")) {
                    error = I18n.translate((String)"labygpt.messages.invalidBearer", (Object[])new Object[0]);
                }
                successful = false;
            } else if (responseBody.choices.isEmpty()) {
                successful = false;
            } else {
                GPTMessage message = responseBody.choices.getFirst().message;
                output = message.content.replace("\n\n", "");
                queryHistory.add(new GPTMessage(output, GPTMessage.GPTRole.Assistant, username));
                successful = true;
            }
            responseConsumer.accept(new ApiResponse(successful, output, error));
        });
    }

    public record ApiResponse(boolean successful, String output, String error) {
    }
}

