/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.labygpt.core.command;

import com.rappytv.labygpt.api.GPTMessage;
import com.rappytv.labygpt.api.GPTRequest;
import com.rappytv.labygpt.core.GPTAddon;
import com.rappytv.labygpt.core.config.GPTAddonConfig;
import java.util.Objects;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.chat.command.SubCommand;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.util.I18n;

public class GPTCommand
extends Command {
    private final GPTAddon addon;

    public GPTCommand(GPTAddon addon) {
        super("gpt", new String[0]);
        this.addon = addon;
        this.withSubCommand(new ClearSubCommand());
        this.withSubCommand(new HistorySubCommand());
    }

    public boolean execute(String prefix, String[] arguments) {
        if (((GPTAddonConfig)this.addon.configuration()).openAI().bearer().isEmpty()) {
            this.displayMessage(((TextComponent)Component.empty().append(GPTAddon.prefix)).append((Component)Component.translatable((String)"labygpt.messages.noKey", (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (arguments.length < 1) {
            this.displayMessage(((TextComponent)Component.empty().append(GPTAddon.prefix)).append((Component)Component.translatable((String)"labygpt.messages.noQuery", (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (!((GPTAddonConfig)this.addon.configuration()).saveHistory().booleanValue()) {
            GPTRequest.queryHistory.clear();
        }
        GPTRequest.sendRequestAsync(String.join((CharSequence)" ", arguments), ((GPTAddonConfig)this.addon.configuration()).openAI().bearer(), ((GPTAddonConfig)this.addon.configuration()).openAI().shareUsername() != false ? this.labyAPI.getName() : "", ((String)((GPTAddonConfig)this.addon.configuration()).gpt().model().get()).toLowerCase(), (String)((GPTAddonConfig)this.addon.configuration()).gpt().behavior().get(), response -> {
            if (!response.successful() || response.output() == null) {
                GPTRequest.queryHistory.removeLast();
                this.displayMessage(((TextComponent)Component.empty().append(GPTAddon.prefix)).append((Component)Component.text((String)Objects.requireNonNullElse(response.error(), I18n.translate((String)"labygpt.messages.requestError", (Object[])new Object[0])), (TextColor)NamedTextColor.RED)));
            } else {
                this.displayMessage(((TextComponent)Component.empty().append(GPTAddon.prefix)).append((Component)Component.text((String)response.output(), (TextColor)NamedTextColor.WHITE)));
            }
        });
        return true;
    }

    public static class ClearSubCommand
    extends SubCommand {
        public ClearSubCommand() {
            super("clear", new String[0]);
        }

        public boolean execute(String prefix, String[] arguments) {
            if (GPTRequest.queryHistory.isEmpty()) {
                this.displayMessage(((TextComponent)Component.empty().append(GPTAddon.prefix)).append((Component)Component.translatable((String)"labygpt.messages.alreadyEmptyHistory", (TextColor)NamedTextColor.RED)));
                return true;
            }
            GPTRequest.queryHistory.clear();
            this.displayMessage(((TextComponent)Component.empty().append(GPTAddon.prefix)).append((Component)Component.translatable((String)"labygpt.messages.historyCleared", (TextColor)NamedTextColor.GREEN)));
            return true;
        }
    }

    public static class HistorySubCommand
    extends SubCommand {
        public HistorySubCommand() {
            super("history", new String[0]);
        }

        public boolean execute(String prefix, String[] arguments) {
            if (GPTRequest.queryHistory.size() < 2) {
                this.displayMessage(((TextComponent)Component.empty().append(GPTAddon.prefix)).append((Component)Component.translatable((String)"labygpt.messages.emptyHistory", (TextColor)NamedTextColor.RED)));
                return true;
            }
            TextComponent component = Component.empty();
            for (int i = 0; i < GPTRequest.queryHistory.size(); ++i) {
                String name;
                GPTMessage message = GPTRequest.queryHistory.get(i);
                String string = name = message.name.isEmpty() ? this.labyAPI.getName() : message.name;
                if (message.role == GPTMessage.GPTRole.System) continue;
                component.append((Component)Component.text((String)(i == 0 ? "" : "\n"))).append((Component)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((String)name)).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((String)message.content.replace("\n\n", ""), (TextColor)NamedTextColor.WHITE));
            }
            this.displayMessage((Component)component);
            return true;
        }
    }
}

