/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.api.map;

import net.labymod.addons.minimap.api.map.MinimapDisplayType;
import net.labymod.api.client.gui.hud.position.HudSize;

public class MinimapCircle {
    private MinimapDisplayType displayType = MinimapDisplayType.ROUND;
    private HudSize size;
    private float distanceToCorner;
    private float circleX;
    private float circleY;

    public void init(MinimapDisplayType displayType, HudSize size, float distanceToCorner) {
        this.displayType = displayType;
        this.size = size;
        this.distanceToCorner = distanceToCorner;
    }

    public void calculate(double radians) {
        float radius = this.size.getActualWidth() / 2.0f;
        radius *= 0.95f;
        boolean circle = this.displayType.isCircle();
        float rotCenterX = this.size.getActualWidth() / 2.0f;
        float rotCenterY = this.size.getActualHeight() / 2.0f;
        float offsetCos = (float)Math.cos(-radians);
        float offsetSin = (float)Math.sin(-radians);
        offsetCos *= circle ? radius : this.distanceToCorner;
        offsetSin *= circle ? radius : this.distanceToCorner;
        if (offsetCos < -radius) {
            offsetCos = -radius;
        }
        if (offsetSin < -radius) {
            offsetSin = -radius;
        }
        if (offsetCos > radius) {
            offsetCos = radius;
        }
        if (offsetSin > radius) {
            offsetSin = radius;
        }
        this.circleX = rotCenterX + offsetCos;
        this.circleY = rotCenterY + offsetSin;
    }

    public float getCircleX() {
        return this.circleX;
    }

    public float getCircleY() {
        return this.circleY;
    }

    public float getDistanceToCorner() {
        return this.distanceToCorner;
    }
}

