/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.api.util;

import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.resources.texture.ThemeTextureLocation;
import net.labymod.api.client.world.chunk.Chunk;
import net.labymod.api.util.color.format.ColorFormat;

public final class Util {
    public static final String NAMESPACE = "labysminimap";
    public static final float BORDER_PADDING = 5.0f;
    public static final float SHADOW_OFFSET = 0.5f;
    public static final float SHADOW_SCALE = 0.25f;
    public static final int SHADOW_COLOR = Util.applyShadowColor(-1);
    public static final float MINIMAP_SCALE = 0.95f;
    private static final long BITS = 32L;
    private static final long MASK = 0xFFFFFFFFL;

    public static ResourceLocation newDefaultNamespace(String path) {
        return ResourceLocation.create((String)NAMESPACE, (String)path);
    }

    public static ThemeTextureLocation newThemeLocation(String path) {
        return ThemeTextureLocation.of((String)("labysminimap:" + path));
    }

    public static long getChunkId(Chunk chunk) {
        return Util.getChunkId(chunk.getChunkX(), chunk.getChunkZ());
    }

    public static long getChunkId(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    public static int applyShadowColor(int argb) {
        return ColorFormat.ARGB32.mul(argb, 0.25f, 0.25f, 0.25f, 1.0f);
    }
}

