/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.data.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.labymod.addons.minimap.data.ChunkData;
import net.labymod.addons.minimap.data.LocalChunkData;
import net.labymod.addons.minimap.util.Compression;
import net.labymod.api.util.io.IOUtil;
import net.labymod.api.util.logging.Logging;
import org.jetbrains.annotations.NotNull;

public class LocalChunkDataWriter
implements AutoCloseable {
    private static final Logging LOGGER = Logging.getLogger();
    private final Path destination;

    private LocalChunkDataWriter(Path destination) {
        this.destination = destination;
    }

    public static LocalChunkDataWriter open(Path destination) throws IOException {
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        return new LocalChunkDataWriter(destination);
    }

    public void write(ChunkData data) throws IOException {
        LocalChunkData localChunkData = new LocalChunkData();
        localChunkData.setPosition(data.getX(), data.getZ());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                localChunkData.setColor(x, z, data.getColor(x, z));
                localChunkData.setHeight(x, z, data.getHeight(x, z));
                localChunkData.setLightLevel(x, z, data.getLightLevel(x, z));
            }
        }
        Path chunksDirectory = this.destination.resolve("chunks");
        Path cachedChunkData = chunksDirectory.resolve(data.getX() + "x" + data.getZ() + ".dat");
        Files.createDirectories(chunksDirectory, new FileAttribute[0]);
        Files.write(cachedChunkData, Compression.deflate(localChunkData.getRawBuffer()), new OpenOption[0]);
    }

    @Override
    public void close() throws Exception {
        LocalChunkDataWriter.zipDirectory(this.destination, this.destination.resolveSibling(this.destination.getFileName().toString() + ".zip"));
        Files.walkFileTree(this.destination, new DeleteVisitor());
    }

    public static void zipDirectory(Path directory, Path zipDestination) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(zipDestination, new OpenOption[0]);
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            LocalChunkDataWriter.zipFiles(directory, directory.getFileName().toString(), zipOutputStream);
        }
    }

    private static void zipFiles(Path file, String fileName, ZipOutputStream outputStream) throws IOException {
        if (Files.isHidden(file)) {
            return;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            if (!((String)fileName).endsWith("/")) {
                fileName = (String)fileName + "/";
            }
            outputStream.putNextEntry(new ZipEntry((String)fileName));
            outputStream.closeEntry();
            try (Stream<@NotNull Path> files = Files.list(file);){
                Object finalFileName = fileName;
                files.forEach(arg_0 -> LocalChunkDataWriter.lambda$zipFiles$0((String)finalFileName, outputStream, arg_0));
            }
        }
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            ZipEntry entry = new ZipEntry((String)fileName);
            outputStream.putNextEntry(entry);
            stream.transferTo(outputStream);
            outputStream.closeEntry();
        }
    }

    private static /* synthetic */ void lambda$zipFiles$0(String finalFileName, ZipOutputStream outputStream, Path child) {
        try {
            LocalChunkDataWriter.zipFiles(child, finalFileName + String.valueOf(child.getFileName()), outputStream);
        }
        catch (IOException exception) {
            LOGGER.error((CharSequence)"Error zipping file", (Throwable)exception);
        }
    }

    public static class DeleteVisitor
    extends SimpleFileVisitor<Path> {
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            IOUtil.delete((Path)file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            IOUtil.delete((Path)dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

