/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.util;

import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.world.ClientWorld;
import net.labymod.api.client.world.block.BlockState;
import net.labymod.api.client.world.chunk.Chunk;
import net.labymod.api.client.world.chunk.HeightmapType;
import net.labymod.api.client.world.lighting.LightType;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.math.position.Position;
import org.jetbrains.annotations.Nullable;

public final class PlayerUtil {
    public static boolean isPlayerUnderground(ClientWorld level, @Nullable ClientPlayer player, int threshold) {
        return PlayerUtil.isPlayerUndergroundBySkylight(level, player) || PlayerUtil.isPlayerUndergroundByObstruction(level, player, threshold);
    }

    private static boolean isPlayerUndergroundBySkylight(ClientWorld level, @Nullable ClientPlayer player) {
        int z;
        int y;
        if (player == null) {
            return false;
        }
        Position position = player.position();
        int x = MathHelper.floor((double)position.getX());
        int skyLight = level.getBlockState(x, y = MathHelper.floor((double)(position.getY() + (double)player.getEyeHeight())), z = MathHelper.floor((double)position.getZ())).getLightLevel(LightType.SKY);
        return skyLight == 0;
    }

    private static boolean isPlayerUndergroundBySurface(ClientWorld level, @Nullable ClientPlayer player, int threshold) {
        if (player == null) {
            return false;
        }
        Position position = player.position();
        int x = MathHelper.floor((double)position.getX());
        int y = MathHelper.floor((double)position.getY());
        int z = MathHelper.floor((double)position.getZ());
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int inChunkX = x & 0xF;
        int inChunkZ = z & 0xF;
        Chunk chunk = level.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            return false;
        }
        int surfaceY = chunk.heightmap(HeightmapType.WORLD_SURFACE).getHeight(inChunkX, inChunkZ);
        return surfaceY - y > threshold;
    }

    private static boolean isPlayerUndergroundByObstruction(ClientWorld level, @Nullable ClientPlayer player, int scanUp) {
        int x;
        if (player == null) {
            return false;
        }
        Position position = player.position();
        int y = MathHelper.floor((double)(position.getY() + (double)player.getEyeHeight()));
        int z = MathHelper.floor((double)position.getZ());
        int maxY = level.getMaxBuildHeight();
        int scanX = x - 1;
        for (x = MathHelper.floor((double)position.getX()); x <= Math.min(maxY, x + scanUp); ++x) {
            int scanZ = z - 1;
            while (z <= Math.min(maxY, z + scanUp)) {
                BlockState state = level.getBlockState(scanX, y, scanZ);
                if (state != null && !state.block().isAir()) {
                    return true;
                }
                ++z;
            }
        }
        return false;
    }
}

