/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.integration.waypoints;

import java.util.Collection;
import net.labymod.addons.minimap.api.config.MinimapConfigProvider;
import net.labymod.addons.minimap.api.event.MinimapRenderEvent;
import net.labymod.addons.minimap.api.renderer.TileRenderer;
import net.labymod.addons.minimap.api.util.Util;
import net.labymod.addons.minimap.integration.waypoints.WaypointsIntegration;
import net.labymod.api.Laby;
import net.labymod.api.client.gfx.pipeline.renderer.text.FormattedTextLayout;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.util.Color;
import net.labymod.api.util.math.MathHelper;

public class WaypointsTileRenderer
extends TileRenderer<WaypointsIntegration.WaypointContainer> {
    private final WaypointsIntegration integration;
    private final FormattedTextLayout.Factory factory;

    public WaypointsTileRenderer(WaypointsIntegration integration, MinimapConfigProvider configProvider) {
        super(configProvider);
        this.integration = integration;
        this.factory = Laby.references().formattedTextLayoutFactory();
    }

    @Override
    protected void renderTile(ScreenContext context, WaypointsIntegration.WaypointContainer waypoint) {
        float diff;
        int alpha;
        float maxDistance;
        ScreenCanvas canvas = context.canvas();
        float distance = this.getCurrentDistance();
        if (distance < (maxDistance = 24.0f) && (alpha = (int)(255.0f * (diff = (maxDistance - distance) / maxDistance))) > 3) {
            float scale = 0.33f;
            canvas.submitComponent(waypoint.title(), 0.0f, -8.0f - canvas.getLineHeight() * scale, Color.withAlpha((int)0xFFFFFF, (int)alpha), Color.withAlpha((int)0, (int)MathHelper.clamp((int)alpha, (int)0, (int)100)), scale, 3);
        }
        Icon icon = waypoint.icon();
        context.pushStack();
        context.translate(0.5f, 0.5f, 0.0f);
        int iconColor = waypoint.iconColor();
        canvas.submitIcon(icon, -3.25f, -8.0f, 8.0f, 8.0f, false, Util.applyShadowColor(iconColor));
        context.popStack();
        canvas.submitIcon(icon, -3.25f, -8.0f, 8.0f, 8.0f, false, iconColor);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.configProvider().hudWidgetConfig().showWaypoints().get();
    }

    @Override
    protected float getTileX(WaypointsIntegration.WaypointContainer waypoint) {
        return (float)waypoint.position().getX();
    }

    @Override
    protected float getTileZ(WaypointsIntegration.WaypointContainer waypoint) {
        return (float)waypoint.position().getZ();
    }

    @Override
    protected boolean shouldRender(MinimapRenderEvent.Stage stage) {
        return stage == MinimapRenderEvent.Stage.STRAIGHT_ZOOMED;
    }

    @Override
    protected Collection<WaypointsIntegration.WaypointContainer> getTiles() {
        return this.integration.getWaypoints();
    }
}

