/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.data;

import java.nio.ByteBuffer;
import net.labymod.addons.minimap.data.ChunkData;
import net.labymod.api.client.world.lighting.LightType;

public class LocalChunkData
extends ChunkData {
    private static final int CHUNK_X_POSITION = 0;
    private static final int CHUNK_Z_POSITION = 4;
    private static final int CHUNK_POSITION_OFFSET = 8;
    private static final int COLOR_SIZE = 4;
    private static final int HEIGHTMAP_SIZE = 4;
    private static final int LIGHT_LEVEL_SIZE = 1;
    private static final int COMPONENT_SIZE = 9;
    private static final int BUFFER_SIZE = 2312;
    private final ByteBuffer buffer;

    public LocalChunkData() {
        this.buffer = ByteBuffer.allocate(2312);
    }

    public LocalChunkData(byte[] buffer) {
        if (buffer.length < 2312 || buffer.length > 2312) {
            throw new IllegalStateException("Invalid chunk data");
        }
        this.buffer = ByteBuffer.wrap(buffer);
    }

    public void setPosition(int x, int z) {
        this.buffer.putInt(0, x);
        this.buffer.putInt(4, z);
    }

    @Override
    public int getHeight(int x, int z) {
        return this.buffer.getInt(this.getBufferIndex(x, z, 4));
    }

    @Override
    public void setHeight(int x, int z, int height) {
        int index = this.getBufferIndex(x, z, 4);
        this.buffer.putInt(index, height);
    }

    @Override
    public int getColor(int x, int z) {
        return this.buffer.getInt(this.getBufferIndex(x, z, 0));
    }

    @Override
    public void setColor(int x, int z, int color) {
        int index = this.getBufferIndex(x, z, 0);
        this.buffer.putInt(index, color);
    }

    @Override
    public int getLightLevel(int x, int z) {
        return this.buffer.get(this.getBufferIndex(x, z, 8));
    }

    @Override
    public int getLightLevel(LightType type, int x, int z) {
        byte lightLevel = this.buffer.get(this.getBufferIndex(x, z, 8));
        return switch (type) {
            default -> throw new MatchException(null, null);
            case LightType.SKY -> lightLevel >> 4;
            case LightType.BLOCK -> lightLevel & 0xF;
        };
    }

    @Override
    public void setLightLevel(int x, int z, int combinedLightLevel) {
        int index = this.getBufferIndex(x, z, 8);
        this.buffer.put(index, (byte)combinedLightLevel);
    }

    @Override
    public int getX() {
        return this.buffer.getInt(0);
    }

    @Override
    public int getZ() {
        return this.buffer.getInt(4);
    }

    public byte[] getRawBuffer() {
        byte[] destination = new byte[2312];
        this.buffer.get(destination);
        return destination;
    }

    private int getBufferIndex(int x, int z, int offset) {
        return 8 + (z * 16 + x) * 9 + offset;
    }
}

