/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class Compression {
    private static final int BUFFER_SIZE = 1024;

    private Compression() {
    }

    public static byte[] deflate(byte[] data) {
        byte[] byArray;
        Deflater deflater = new Deflater();
        deflater.setLevel(1);
        deflater.setInput(data);
        deflater.finish();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        try {
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int length = deflater.deflate(buffer);
                outputStream.write(buffer, 0, length);
            }
            deflater.end();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalStateException(exception);
            }
        }
        outputStream.close();
        return byArray;
    }

    public static byte[] inflate(byte[] data) throws DataFormatException {
        byte[] byArray;
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        try {
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int length = inflater.inflate(buffer);
                outputStream.write(buffer, 0, length);
            }
            inflater.end();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalStateException(exception);
            }
        }
        outputStream.close();
        return byArray;
    }
}

