/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.integration.waypoints;

import java.util.ArrayList;
import java.util.List;
import net.labymod.addons.minimap.MinimapAddon;
import net.labymod.addons.minimap.api.config.MinimapConfigProvider;
import net.labymod.addons.minimap.integration.waypoints.WaypointsTileRenderer;
import net.labymod.addons.waypoints.Waypoints;
import net.labymod.addons.waypoints.event.RefreshWaypointsEvent;
import net.labymod.addons.waypoints.waypoint.Waypoint;
import net.labymod.addons.waypoints.waypoint.WaypointType;
import net.labymod.api.Laby;
import net.labymod.api.addon.integration.AddonIntegration;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.event.Subscribe;
import net.labymod.api.util.Color;
import net.labymod.api.util.math.vector.DoubleVector3;

public class WaypointsIntegration
implements AddonIntegration {
    private final List<WaypointContainer> waypointContainers = new ArrayList<WaypointContainer>();

    public void load() {
    }

    public void onIntegratedAddonEnable() {
        Laby.labyAPI().eventBus().registerListener((Object)this);
        MinimapAddon.getReferences().tileRendererDispatcher().register(configProvider -> new WaypointsTileRenderer(this, (MinimapConfigProvider)configProvider));
    }

    public void onIntegratedAddonDisable() {
        Laby.labyAPI().eventBus().unregisterListener((Object)this);
    }

    @Subscribe
    public void onRefreshWaypoints(RefreshWaypointsEvent event) {
        this.waypointContainers.clear();
        for (Waypoint visibleWaypoint : Waypoints.references().waypointService().getVisible()) {
            this.waypointContainers.add(new WaypointContainer(visibleWaypoint));
        }
    }

    public List<WaypointContainer> getWaypoints() {
        return this.waypointContainers;
    }

    public record WaypointContainer(Waypoint waypoint, DoubleVector3 position) {
        public WaypointContainer(Waypoint waypoint) {
            this(waypoint, waypoint.position().copy());
        }

        public WaypointType type() {
            return this.waypoint.type();
        }

        public int iconColor() {
            return this.waypoint.meta().iconColor();
        }

        public Color color() {
            return this.waypoint.color();
        }

        public Icon icon() {
            return this.waypoint.meta().icon();
        }

        public Component title() {
            return this.waypoint.title();
        }
    }
}

