/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.map.v2;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import net.labymod.addons.minimap.MinimapContext;
import net.labymod.addons.minimap.api.config.MinimapConfigProvider;
import net.labymod.addons.minimap.api.map.MinimapBounds;
import net.labymod.addons.minimap.api.util.Util;
import net.labymod.addons.minimap.data.ChunkData;
import net.labymod.addons.minimap.data.ChunkDataStorage;
import net.labymod.addons.minimap.gui.state.MinimapGuiBlitRenderState;
import net.labymod.addons.minimap.laby3d.MinimapRenderStates;
import net.labymod.addons.minimap.laby3d.MinimapUniformBlocks;
import net.labymod.addons.minimap.laby3d.shader.MinimapUniformBlock;
import net.labymod.addons.minimap.map.v2.DaylightPeriod;
import net.labymod.addons.minimap.map.v2.texture.CompositeSectionTexture;
import net.labymod.addons.minimap.map.v2.texture.SectionTexture;
import net.labymod.addons.minimap.map.v2.texture.SectionTextureRepository;
import net.labymod.addons.minimap.util.PlayerUtil;
import net.labymod.api.Laby;
import net.labymod.api.client.entity.player.ClientPlayer;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.state.states.GuiTextureSet;
import net.labymod.api.client.gui.screen.util.scissor.ScissorArea;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.world.ClientWorld;
import net.labymod.api.util.Lazy;
import net.labymod.api.util.color.format.ColorFormat;
import net.labymod.api.util.logging.Logging;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.math.position.Position;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class MinimapRenderer {
    private static final Logging LOGGER = Logging.getLogger();
    private final MinimapBounds minimapBounds = new MinimapBounds();
    private final MinimapConfigProvider configProvider;
    private final SectionTextureRepository sectionTextureRepository;
    private final ChunkDataStorage storage;
    private final MinimapUniformBlocks uniformBlocks;
    private final Lazy<Icon> dummyMinimap;
    private DaylightPeriod currentPeriod = DaylightPeriod.DAYTIME;
    private boolean lastUnderground = false;
    private int lastMidChunkX;
    private int lastMidChunkZ;
    private int lastPlayerY;
    private int lastZoom;
    private boolean changed = true;

    public MinimapRenderer(MinimapConfigProvider configProvider, MinimapContext minimapContext) {
        this.configProvider = configProvider;
        this.sectionTextureRepository = minimapContext.sectionTextureRepository();
        this.storage = minimapContext.storage();
        this.uniformBlocks = minimapContext.uniformBlocks();
        this.dummyMinimap = Lazy.of(() -> Icon.texture((ResourceLocation)Util.newDefaultNamespace("themes/vanilla/textures/dummy_minimap.png")));
    }

    public void tick() {
        this.refreshMinimap();
    }

    public void setZoomSupplier(IntSupplier zoomSupplier) {
    }

    public MinimapBounds minimapBounds() {
        return this.minimapBounds;
    }

    public void renderMinimap(BooleanSupplier allowed, Runnable renderer) {
        if (!allowed.getAsBoolean()) {
            return;
        }
        renderer.run();
    }

    public void renderDummyMinimap(ScreenContext context, float x, float y, float width, float height) {
        context.canvas().submitIcon((Icon)this.dummyMinimap.get(), x, y, width, height);
    }

    public void render(ScreenContext context, float x, float y, float width, float height) {
        ScreenCanvas canvas = context.canvas();
        int x1 = this.minimapBounds.getX1();
        int z1 = this.minimapBounds.getZ1();
        int x2 = this.minimapBounds.getX2();
        int z2 = this.minimapBounds.getZ2();
        if (x2 <= x1 || z2 <= z1) {
            return;
        }
        float pxPerBlockX = width / (float)(x2 - x1);
        float pxPerBlockZ = height / (float)(z2 - z1);
        MinimapUniformBlock minimap = this.uniformBlocks.minimap();
        minimap.sunPosition().set((Object)new Vector3f(0.9f, -1.0f, 1.0f));
        float timeOfDay = this.getTimeOfDay();
        float normalizedDayTime = (float)(1.0 - (Math.cos(timeOfDay * ((float)Math.PI * 2)) * 2.0 + (double)0.2f));
        normalizedDayTime = MathHelper.clamp((float)normalizedDayTime, (float)0.0f, (float)1.0f);
        normalizedDayTime = 1.0f - normalizedDayTime;
        minimap.pixelSize().set((Object)new Vector3f(1.0f / width, 1.0f / height, 0.0f));
        minimap.dayTime().set((Object)Float.valueOf(normalizedDayTime));
        int minChunkX = Math.floorDiv(x1, 16);
        int minChunkZ = Math.floorDiv(z1, 16);
        int maxChunkX = Math.floorDiv(x2 - 1, 16);
        int maxChunkZ = Math.floorDiv(z2 - 1, 16);
        int minSecX = Math.floorDiv(minChunkX, 8);
        int minSecZ = Math.floorDiv(minChunkZ, 8);
        int maxSecX = Math.floorDiv(maxChunkX, 8);
        int maxSecZ = Math.floorDiv(maxChunkZ, 8);
        for (int secX = minSecX; secX <= maxSecX; ++secX) {
            for (int secZ = minSecZ; secZ <= maxSecZ; ++secZ) {
                CompositeSectionTexture composite = this.sectionTextureRepository.getSectionTexture(secX, secZ);
                if (composite == null) continue;
                int secMinBlockX = secX * 8 << 4;
                int secMinBlockZ = secZ * 8 << 4;
                int secBlocksX = 128;
                int secBlocksZ = 128;
                int secMaxBlockX = secMinBlockX + secBlocksX;
                int secMaxBlockZ = secMinBlockZ + secBlocksZ;
                int visMinBlockX = Math.max(secMinBlockX, x1);
                int visMinBlockZ = Math.max(secMinBlockZ, z1);
                int visMaxBlockX = Math.min(secMaxBlockX, x2);
                int visMaxBlockZ = Math.min(secMaxBlockZ, z2);
                if (visMaxBlockX <= visMinBlockX || visMaxBlockZ <= visMinBlockZ) continue;
                float u0 = (float)(visMinBlockX - secMinBlockX) / (float)secBlocksX;
                float v0 = (float)(visMinBlockZ - secMinBlockZ) / (float)secBlocksZ;
                float u1 = (float)(visMaxBlockX - secMinBlockX) / (float)secBlocksX;
                float v1 = (float)(visMaxBlockZ - secMinBlockZ) / (float)secBlocksZ;
                float dstX = x + (float)(visMinBlockX - x1) * pxPerBlockX;
                float dstY = y + (float)(visMinBlockZ - z1) * pxPerBlockZ;
                float dstW = (float)(visMaxBlockX - visMinBlockX) * pxPerBlockX;
                float dstH = (float)(visMaxBlockZ - visMinBlockZ) * pxPerBlockZ;
                SectionTexture colorTexture = composite.getTexture(SectionTexture.Variant.COLOR);
                SectionTexture heightmapTexture = composite.getTexture(SectionTexture.Variant.HEIGHTMAP);
                SectionTexture lightmapTexture = composite.getTexture(SectionTexture.Variant.LIGHTMAP);
                canvas.submitState((pose, scissorArea) -> new MinimapGuiBlitRenderState(MinimapRenderStates.MINIMAP, (Matrix4f)pose, GuiTextureSet.builder().setTexture(0, colorTexture.deviceTextureView()).setTexture(1, heightmapTexture.deviceTextureView()).setTexture(2, lightmapTexture.deviceTextureView()).build(), dstX, dstY, dstW, dstH, u0, v0, u1, v1, -1, (ScissorArea)scissorArea, this.uniformBlocks));
            }
        }
    }

    private void refreshMinimap() {
        int py;
        boolean changeLevel;
        ClientPlayer player = Laby.labyAPI().minecraft().getClientPlayer();
        if (player == null) {
            return;
        }
        if (Laby.labyAPI().minecraft().isKeyPressed(Key.O)) {
            this.storage.resetCompilations();
        }
        long dayTime = this.getDayTime();
        this.setDaylightPeriod(DaylightPeriod.findByTime(dayTime));
        ClientWorld level = Laby.labyAPI().minecraft().clientWorld();
        int minBuildHeight = level.getMinBuildHeight();
        int maxBuildHeight = level.getMaxBuildHeight();
        Position position = player.position();
        int midX = MathHelper.floor((double)position.getX());
        int midZ = MathHelper.floor((double)position.getZ());
        int zoom = (Integer)this.configProvider.hudWidgetConfig().zoom().get() * 10;
        int minX = midX - zoom;
        int minZ = midZ - zoom;
        int maxX = midX + zoom;
        int maxZ = midZ + zoom;
        int midChunkX = midX >> 4;
        int midChunkZ = midZ >> 4;
        boolean underground = false;
        if (((Boolean)this.configProvider.hudWidgetConfig().caveMode().get()).booleanValue()) {
            underground = PlayerUtil.isPlayerUnderground(level, player, 2);
        }
        this.storage.setPlayerPosition(player.position(), underground);
        int minChunkX = minX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkX = maxX >> 4;
        int maxChunkZ = maxZ >> 4;
        ColorFormat format = ColorFormat.ARGB32;
        if (this.changed || this.storage.shouldProcess()) {
            this.changed = false;
            this.forEach(minChunkX, minChunkZ, maxChunkX, maxChunkZ, (chunkX, chunkZ, chunk) -> {
                this.storage.compile(chunk);
                CompositeSectionTexture texture = this.sectionTextureRepository.getOrCreateSectionTexture(chunkX, chunkZ);
                SectionTexture colorTexture = texture.getTexture(SectionTexture.Variant.COLOR);
                SectionTexture heightmapTexture = texture.getTexture(SectionTexture.Variant.HEIGHTMAP);
                SectionTexture lightmapTexture = texture.getTexture(SectionTexture.Variant.LIGHTMAP);
                int localChunkX = Math.floorMod(chunkX, 8);
                int localChunkZ = Math.floorMod(chunkZ, 8);
                int basePixelX = localChunkX * 16;
                int basePixelZ = localChunkZ * 16;
                for (int pixelX = 0; pixelX < 16; ++pixelX) {
                    for (int pixelZ = 0; pixelZ < 16; ++pixelZ) {
                        int destX = basePixelX + pixelX;
                        int destZ = basePixelZ + pixelZ;
                        int tileColor = chunk.getColor(pixelX, pixelZ);
                        int height = chunk.getHeight(pixelX, pixelZ);
                        float normalized = (float)(height - minBuildHeight) * 1.0f / (float)(maxBuildHeight - minBuildHeight) + 0.0f;
                        int heightmapColor = format.pack(normalized, normalized, normalized, 1.0f);
                        colorTexture.image().setARGB(destX, destZ, tileColor);
                        colorTexture.image().setARGB(destX, destZ, tileColor);
                        colorTexture.image().setARGB(destX, destZ, tileColor);
                        colorTexture.image().setARGB(destX, destZ, tileColor);
                        heightmapTexture.image().setARGB(destX, destZ, heightmapColor);
                        int blockLightLevel = chunk.getBlockLightLevel(pixelX, pixelZ);
                        int normalizedLightLevel = this.normalize(blockLightLevel);
                        boolean noBlockLighting = normalizedLightLevel == 150;
                        lightmapTexture.image().setARGB(destX, destZ, format.pack(noBlockLighting ? 0 : normalizedLightLevel, noBlockLighting ? 0 : normalizedLightLevel, noBlockLighting ? 0 : normalizedLightLevel, noBlockLighting ? 0 : 255));
                    }
                }
                texture.updateTexture();
            });
            this.minimapBounds.update(minX, minZ, maxX, maxZ, 0);
            this.storage.processed();
        }
        boolean bl = changeLevel = (py = MathHelper.floor((double)position.getY())) < this.lastPlayerY - 5 || py > this.lastPlayerY + 5;
        if (this.lastMidChunkX != midChunkX && this.lastMidChunkZ != midChunkZ || this.lastUnderground != underground || this.lastZoom != zoom || changeLevel) {
            this.lastMidChunkX = midChunkX;
            this.lastMidChunkZ = midChunkZ;
            if (this.lastUnderground != underground) {
                this.storage.resetCompilations();
            }
            if (underground && this.lastPlayerY != py) {
                this.storage.resetCompilations();
            }
            this.lastUnderground = underground;
            this.lastPlayerY = py;
            this.lastZoom = zoom;
            this.changed = true;
        }
    }

    private void forEach(int minX, int minZ, int maxX, int maxZ, ChunkConsumer consumer) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                ChunkData chunk = this.storage.getChunk(chunkX, chunkZ);
                if (chunk == null || this.storage.isCompiled(chunk)) continue;
                consumer.accept(chunkX, chunkZ, chunk);
            }
        }
    }

    private int normalize(int value) {
        return this.normalize(value, 0, 15, 10, 255);
    }

    private int normalize(int value, int oldMin, int oldMax, int newMin, int newMax) {
        return (value - oldMin) * (newMax - newMin) / (oldMax - oldMin) + newMin;
    }

    private float getTimeOfDay() {
        long dayTime = this.getDayTime();
        double timeFraction = this.frac((double)dayTime / 24000.0 - 0.25);
        double timeOfDay = 0.5 - Math.cos(timeFraction * Math.PI) / 2.0;
        return (float)(timeFraction * 2.0 + timeOfDay) / 3.0f;
    }

    private double frac(double value) {
        return value - Math.floor(value);
    }

    private void setDaylightPeriod(DaylightPeriod period) {
        if (this.currentPeriod == period) {
            return;
        }
        System.out.println("Changed period from " + String.valueOf(this.currentPeriod) + " to " + String.valueOf(period));
        this.currentPeriod = period;
    }

    private long getDayTime() {
        return Laby.references().clientWorld().getDayTime() % 24000L;
    }

    @FunctionalInterface
    public static interface ChunkConsumer {
        public void accept(int var1, int var2, ChunkData var3);
    }
}

