/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.data.compilation;

import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.labymod.addons.minimap.data.ChunkData;
import net.labymod.addons.minimap.data.GameChunkData;
import net.labymod.addons.minimap.data.compilation.ChunkCompiler;
import net.labymod.api.Laby;
import net.labymod.api.client.world.ClientWorld;
import net.labymod.api.client.world.block.Block;
import net.labymod.api.client.world.block.BlockColorProvider;
import net.labymod.api.client.world.block.BlockState;
import net.labymod.api.client.world.chunk.Chunk;
import net.labymod.api.generated.ReferenceStorage;
import net.labymod.api.util.ColorUtil;
import net.labymod.api.util.color.format.ColorFormat;
import net.labymod.api.util.math.vector.IntVector3;

public class GameChunkCompiler
implements ChunkCompiler<GameChunkData> {
    private final BlockColorProvider blockColorProvider;
    private final ClientWorld level;
    private int playerX;
    private int playerY;
    private int playerZ;
    private boolean underground;

    public GameChunkCompiler() {
        ReferenceStorage references = Laby.references();
        this.blockColorProvider = references.blockColorProvider();
        this.level = references.clientWorld();
    }

    @Override
    public boolean isCompatible(ChunkData data) {
        return data instanceof GameChunkData;
    }

    @Override
    public void compile(GameChunkData data) {
        ColorFormat format = ColorFormat.ARGB32;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (this.underground) {
                    this.compileUndergroundChunk(data, format, x, z);
                    continue;
                }
                this.compileOverworldChunk(data, format, x, z);
            }
        }
    }

    @Override
    public void setPlayerPosition(int x, int y, int z, boolean underground) {
        this.playerX = x;
        this.playerY = y;
        this.playerZ = z;
        this.underground = underground;
    }

    private void compileUndergroundChunk(GameChunkData data, ColorFormat format, int x, int z) {
        data.setColor(x, z, -16777216);
        Chunk chunk = data.getChunk();
        int depth = this.playerY;
        int minBuildHeight = this.level.getMinBuildHeight();
        int minScanY = Math.max(minBuildHeight, depth - 20);
        int maxScanY = depth + 2;
        int startY = depth;
        BlockState state = chunk.getBlockState(x, startY, z);
        while (startY > minScanY && (state == null || state.block().isAir())) {
            state = chunk.getBlockState(x, --startY, z);
        }
        if (startY < minScanY) {
            startY = minScanY;
            state = chunk.getBlockState(x, startY, z);
        }
        BlockState above = chunk.getBlockState(x, startY + 1, z);
        for (int y = startY; y <= maxScanY; ++y) {
            if (state != null && !state.block().isAir()) {
                Block aboveBlock;
                if (above != null && !(aboveBlock = above.block()).isAir() && !above.isFluid()) {
                    data.setColor(x, z, -16777216);
                    return;
                }
                int blockY = y;
                BlockState blockAbove = above;
                this.compileChunkColor(data, format, x, z, state, () -> blockY, () -> blockAbove);
                return;
            }
            int nextY = y + 1;
            state = above;
            above = nextY + 1 <= maxScanY + 1 ? chunk.getBlockState(x, nextY + 1, z) : null;
        }
    }

    private void compileOverworldChunk(GameChunkData data, ColorFormat format, int x, int z) {
        Chunk chunk = data.getChunk();
        BlockState highestBlock = this.getBlockState(chunk, x, z);
        BlockState block = this.getBlockState(chunk, x, z);
        if (highestBlock == null || block == null) {
            data.setColor(x, z, -16777216);
            return;
        }
        BlockState above = this.getBlockAbove(chunk, block);
        this.compileChunkColor(data, format, x, z, block, () -> highestBlock.position().getY() - (highestBlock.hasCollision() ? 0 : 1), () -> above);
    }

    private void compileChunkColor(GameChunkData data, ColorFormat format, int x, int z, BlockState block, IntSupplier defaultHeight, Supplier<BlockState> lightLevelGetter) {
        this.compileChunkColor(data, format, x, z, block, defaultHeight.getAsInt(), lightLevelGetter.get());
    }

    private void compileChunkColor(GameChunkData data, ColorFormat format, int x, int z, BlockState block, int defaultHeight, BlockState lightLevelState) {
        int baseColor = this.getBaseColor(format, block);
        data.setHeight(x, z, defaultHeight);
        data.setLightLevel(x, z, lightLevelState);
        if (block.isWater()) {
            BlockState blockStateUnderWater = this.getBlockBelow(data.getChunk(), block, state -> !state.isWater());
            baseColor = format.pack(baseColor, 220);
            int colorUnderWater = format.withAlpha(this.getColor(format, blockStateUnderWater), 255);
            baseColor = ColorUtil.blendColors((int)colorUnderWater, (int)baseColor);
            data.setHeight(x, z, blockStateUnderWater.position().getY());
        }
        data.setColor(x, z, baseColor);
    }

    private int getBaseColor(ColorFormat format, BlockState state) {
        return format.withAlpha(this.getColor(format, state), 255);
    }

    private int getColor(ColorFormat format, BlockState state) {
        int baseColor = this.blockColorProvider.getColor(state);
        int multiplier = this.blockColorProvider.getColorMultiplier(state);
        float redMultiplier = format.normalizedRed(multiplier);
        float greenMultiplier = format.normalizedGreen(multiplier);
        float blueMultiplier = format.normalizedBlue(multiplier);
        return format.mul(baseColor, redMultiplier, greenMultiplier, blueMultiplier, 1.0f);
    }

    private BlockState getBlockState(Chunk chunk, int x, int z) {
        int minBuildHeight = this.level.getMinBuildHeight();
        BlockState blockState = null;
        for (int y = chunk.getHeightBasedOnSection(64); y > minBuildHeight && ((blockState = chunk.getBlockState(x, y, z)) == null || blockState.block().isAir()); --y) {
        }
        return blockState;
    }

    private BlockState getBlockBelow(Chunk chunk, BlockState state, Function<BlockState, Boolean> filter) {
        IntVector3 position = state.position();
        int x = position.getX() & 0xF;
        int z = position.getZ() & 0xF;
        int minBuildHeight = this.level.getMinBuildHeight();
        BlockState blockState = null;
        for (int y = position.getY(); y > minBuildHeight && !filter.apply(blockState = chunk.getBlockState(x, y, z)).booleanValue(); --y) {
        }
        return blockState;
    }

    private BlockState getBlockBelow(Chunk chunk, BlockState state) {
        IntVector3 position = state.position();
        int x = position.getX() & 0xF;
        int y = position.getY();
        int z = position.getZ() & 0xF;
        return chunk.getBlockState(x, y - 1, z);
    }

    private BlockState getBlockAbove(Chunk chunk, BlockState state) {
        IntVector3 position = state.position();
        int x = position.getX() & 0xF;
        int y = position.getY();
        int z = position.getZ() & 0xF;
        return chunk.getBlockState(x, y + 1, z);
    }
}

