/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.map.v2.renderer;

import java.util.Collection;
import net.labymod.addons.minimap.api.config.MinimapConfigProvider;
import net.labymod.addons.minimap.api.renderer.TileRenderer;
import net.labymod.api.Laby;
import net.labymod.api.client.entity.Entity;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.util.Color;

public class EntityTileRenderer
extends TileRenderer<Entity> {
    private static final float MAX_DISTANCE = 4096.0f;
    private static final float SIZE = 1.0f;
    private static final float OFFSET = 0.5f;
    private static final float SCALE = 0.33f;

    public EntityTileRenderer(MinimapConfigProvider configProvider) {
        super(configProvider);
    }

    @Override
    protected boolean shouldRenderTile(Entity entity) {
        if (entity instanceof Player) {
            return false;
        }
        double distanceSquared = this.clientPlayer().getDistanceSquared(entity);
        return !(distanceSquared > 4096.0);
    }

    @Override
    protected void renderTile(ScreenContext context, Entity entity) {
        ScreenCanvas canvas = context.canvas();
        canvas.submitCircle(0.0f, 0.0f, 1.25f, -1);
        context.pushStack();
        context.scale(0.33f, 0.33f);
        canvas.submitComponent(entity.nameComponent(), 0.0f, 1.0f, -1, Color.withAlpha((int)0, (int)100), 0.33f, 1);
        context.popStack();
    }

    @Override
    protected float getTileX(Entity entity) {
        return (float)entity.position().getX();
    }

    @Override
    protected float getTileZ(Entity entity) {
        return (float)entity.position().getZ();
    }

    @Override
    protected Collection<Entity> getTiles() {
        return Laby.references().clientWorld().getEntities();
    }
}

