/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap;

import javax.inject.Singleton;
import net.labymod.addons.minimap.MinimapContext;
import net.labymod.addons.minimap.api.config.MinimapConfig;
import net.labymod.addons.minimap.api.config.MinimapConfigProvider;
import net.labymod.addons.minimap.api.config.MinimapHudWidgetConfig;
import net.labymod.addons.minimap.api.generated.ReferenceStorage;
import net.labymod.addons.minimap.config.MinimapConfiguration;
import net.labymod.addons.minimap.debug.ImGuiMinimapDebug;
import net.labymod.addons.minimap.hudwidget.MinimapHudWidget;
import net.labymod.addons.minimap.integration.waypoints.WaypointsIntegration;
import net.labymod.addons.minimap.map.v2.MinimapRenderer;
import net.labymod.addons.minimap.server.MinimapServers;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.models.Implements;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.laby3d.api.util.Util;

@AddonMain
@Singleton
@Implements(value=MinimapConfigProvider.class)
public class MinimapAddon
extends LabyAddon<MinimapConfiguration>
implements MinimapConfigProvider {
    private final MinimapServers servers = new MinimapServers();
    private static ReferenceStorage references;
    private MinimapRenderer minimapRenderer;
    private MinimapHudWidget hudWidget;

    protected void enable() {
        Util.NATIVE_BOUNDS_CHECK_ENABLED = true;
        this.registerSettingCategory();
        references = (ReferenceStorage)this.referenceStorageAccessor();
        MinimapContext minimapContext = new MinimapContext();
        this.registerListener(minimapContext.storage());
        this.registerListener(minimapContext.uniformBlocks());
        net.labymod.api.generated.ReferenceStorage references = Laby.references();
        this.minimapRenderer = new MinimapRenderer(this, minimapContext);
        this.hudWidget = new MinimapHudWidget(this, this.minimapRenderer);
        references.hudWidgetRegistry().register((Object)this.hudWidget);
        this.servers.init();
        references.addonIntegrationService().registerIntegration("labyswaypoints", WaypointsIntegration.class);
        this.registerListener(MinimapAddon.getReferences().tileRendererDispatcher());
        references.controlEntryRegistry().registerEntry(false, ImGuiMinimapDebug::new);
    }

    protected Class<? extends MinimapConfiguration> configurationClass() {
        return MinimapConfiguration.class;
    }

    public boolean isMinimapAllowed() {
        return this.servers.isCurrentlyAllowed();
    }

    public static ReferenceStorage getReferences() {
        return references;
    }

    @Override
    public MinimapConfig config() {
        return (MinimapConfig)this.configuration();
    }

    @Override
    public MinimapHudWidgetConfig hudWidgetConfig() {
        return (MinimapHudWidgetConfig)this.hudWidget.getConfig();
    }
}

