/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.minimap.activity.widget;

import net.labymod.addons.minimap.api.map.MinimapBounds;
import net.labymod.addons.minimap.map.v2.MinimapRenderer;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.mouse.Mouse;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.state.ScreenCanvas;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.util.math.MathHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

@AutoWidget
public class MapWidget
extends SimpleWidget {
    private final MinimapRenderer renderer;
    private int zoom = 10;

    public MapWidget(MinimapRenderer renderer) {
        this.renderer = renderer;
    }

    public void renderWidget(ScreenContext context) {
        super.renderWidget(context);
        this.renderer.setZoomSupplier(() -> this.zoom);
        this.renderer.renderMinimap(() -> true, () -> {
            Bounds bounds = this.bounds();
            float mapX = bounds.getX();
            float mapY = bounds.getY();
            float mapW = Math.max(bounds.getWidth(), 1.0f);
            float mapH = Math.max(bounds.getHeight(), 1.0f);
            MinimapBounds world = this.renderer.minimapBounds();
            int worldSpanX = Math.max(world.getX2() - world.getX1(), 1);
            int worldSpanZ = Math.max(world.getZ2() - world.getZ1(), 1);
            float texelW = Math.max(1.0f, (float)Math.floor(mapW / (float)worldSpanX));
            float texelH = Math.max(1.0f, (float)Math.floor(mapH / (float)worldSpanZ));
            this.renderer.render(context, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            MutableMouse mouse = context.mouse();
            ScreenCanvas canvas = context.canvas();
            int gridX = (int)Math.floor(((float)mouse.getX() - mapX) / texelW);
            int gridY = (int)Math.floor(((float)mouse.getY() - mapY) / texelH);
            float snappedX = mapX + (float)gridX * texelW;
            float snappedY = mapY + (float)gridY * texelH;
            canvas.submitRelativeRect(snappedX, snappedY, texelW, texelH, -2130706433);
        });
    }

    @Nullable
    public Vector2f resolveBlockCoordinates(Mouse mouse) {
        Bounds bounds = this.bounds();
        float mapX = bounds.getX();
        float mapY = bounds.getY();
        float mapW = bounds.getWidth();
        float mapH = bounds.getHeight();
        float mx = mouse.getX();
        float my = mouse.getY();
        if (mx >= mapX && mx <= mapX + mapW && my >= mapY && my <= mapY + mapH) {
            float u = (mx - mapX) / mapW;
            float v = (my - mapY) / mapH;
            MinimapBounds world = this.renderer.minimapBounds();
            int minX = world.getX1();
            int minZ = world.getZ1();
            int maxX = world.getX2();
            int maxZ = world.getZ2();
            u = MathHelper.clamp((float)u, (float)0.0f, (float)1.0f);
            v = MathHelper.clamp((float)v, (float)0.0f, (float)1.0f);
            int worldX = minX + (int)Math.floor(u * (float)(maxX - minX));
            int worldZ = minZ + (int)Math.floor(v * (float)(maxZ - minZ));
            return new Vector2f((float)worldX, (float)worldZ);
        }
        return null;
    }

    public void tick() {
        super.tick();
        this.renderer.tick();
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
    }

    public boolean mouseScrolled(MutableMouse mouse, double scrollDelta) {
        this.zoom = scrollDelta > 0.0 ? ++this.zoom : --this.zoom;
        this.zoom = MathHelper.clamp((int)this.zoom, (int)2, (int)32);
        return super.mouseScrolled(mouse, scrollDelta);
    }
}

